<?php
$awards = get_sub_field('awards');
if($awards){ 
	?>
<section class="section section--awards-panel" >
    <div class="container">
        <div class="row d-flex justify-content-center">
            <h1 class="accent-title">Award winning and<br/><span>Accompli<span>sH</span>ed</span></h1>
			<?php foreach($awards as $post) {
				setup_postdata($post);
				$productImageId = get_post_thumbnail_id();
				$productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'award-square') : "";
				$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: get_the_title();
				if($productImage) {
					?>
					<a href="<?php if(get_field('call_to_action_url')) { the_field('call_to_action_url'); } else { echo '#'; } ?>">
						<img class="img-fluid" src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
					</a>
				<?php 
				} 
			}
			wp_reset_postdata(); ?>
		</div>
	</div>
</section>

<?php }