<?php get_template_part('templates/person/archive-featured-top'); ?>
<section class="section section--people">
    <div class="container">
        <?php if(is_tax() == false) { ?>
        <div class="row">
            <div class="col-lg-8 order-lg-2">
              <?php 
              if(get_field('ad_panel_image', 'option') && get_field('ad_panel_url', 'option')) { 
                $image = wp_get_attachment_image_src(get_field('ad_panel_image', 'option'), 'ad-vacancy');
                $alt = get_post_meta(get_field('ad_panel_image', 'option'), '_wp_attachment_image_alt', true);
                ?>
                <a target="_blank" href="<?php the_field('ad_panel_url', 'option'); ?>">
                    <img src="<?= $image[0]; ?>" alt="<?= $alt; ?>" />
                </a>
              <?php } ?>
            </div>
            <div class="col-lg-4 order-lg-1">
                <?php
                $categories = get_terms([
                    'taxonomy' => 'area-of-expertise',
                    'hide_empty' => true
                ]);
                ?>
                <select id="select-filter">
                    <option value="all">View staff by area of expertise</option>
                    <option value="all">Full team</option>
                    <?php 
                    if (!empty($categories) && !is_wp_error($categories)) {
                        foreach($categories as $category) {
                            ?>
                            <option value=".<?= $category->slug; ?>"><?= $category->name; ?></option>
                            <?php 
                        }
                    } 
                    ?>
                </select>
            </div>
        </div>
                  <?php } ?>
        <div id="profiles" class="row">
            <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
        </div>
    </div>
</section>
<div class="modal fade" id="personBioModal" tabindex="-1" role="dialog" aria-labelledby="personBioModal" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-person">
        <div class="row">
          <div class="col-md-6">
            <a class="highlight" target="_blank">
                <img class="img-fluid highlight-image" src="" alt="">
            </a>
            
            <img class="img-fluid modal-person-image" src=""/>

          </div>
          <div class="col-md-6">
            <div class="modal-content-wrapper">
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="fas fa-times"></i></button>
              <h2 class="modal-person-name"></h2>
              <h3 class="modal-person-position"></h3>

              <p class="modal-person-content"></p>

              <a class="modal-person-email"></a>

              <a class="modal-person-linkedin"></a>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>


