import '@babel/polyfill'; // Required for build
import load from './loader'; // Required for loading files dynamically
import 'bootstrap/js/dist/util'; // All Bootstrap JS requires Util
import 'bootstrap/js/dist/collapse'; // Used for nav collapse functionality
import 'bootstrap/js/dist/dropdown';
import 'bootstrap/js/dist/modal';
import '@fortawesome/fontawesome-free/js/all';
import '@fortawesome/fontawesome-pro/js/all';
import common from './common';
import 'jquery-ui/themes/base/core.css';
import 'jquery-ui/themes/base/theme.css';
import 'jquery-ui/themes/base/datepicker.css';
import 'jquery-ui/ui/core';
import 'jquery-ui/ui/widgets/datepicker';
/*
    Basic Event Routing
    -------------------
    Switch on body class that gets applied either due to page, post type or page template
    Replace '-' in the class name with '_'
*/
const route = className => {
    switch (className) {

        case 'template_where_to_buy':
        case 'template_where_to_buy_new':
            import('./StoreMap.js').then(StoreMap => {
                new StoreMap.default(); // eslint-disable-line
            });
            load('./woocommerce/swiper');
            break;
        case 'single_post':
            load('./post');
            break;
        case 'woocommerce':
            load('./woocommerce');
            load('./woocommerce/delivery');
            load('./woocommerce/swiper');
            break;
        case 'woocommerce_checkout':
            load('./woocommerce/delivery');
            load('./woocommerce/checkout');
            break;
        case 'recipe_template_default':
            load('./recipe/print');
            load('./recipe');
            break;
        case 'post_type_archive_person':
            load('./people');
            load('./people/filter');
            break;
        case 'tax_area_of_expertise':
            load('./people');
            break;
        case 'home':
            load('./home');
            break;

    }
};

// Fire events once document has loaded
document.addEventListener('DOMContentLoaded', () => {
    common(); // Run common code on every page

    const bodyClasses = document.body.className // Get all body classes,
        .replace(/-/g, '_') // replace dashes with underscores,
        .replace(/page_template_/g, '') // remove prefix 'page_template' from template classes, &
        .split(/\s+/); // split on whitespace

    for (const value of bodyClasses) {
        route(value); // Run javascript for each body class
    }
});
