<?php
$postImgId = get_post_thumbnail_id();
$postImg = $postImgId ? wp_get_attachment_image_src($postImgId, 'news-archive') : 
	[get_template_directory_uri() . "/dist/images/default-800-605.jpg"];
$postImgAlt = get_post_meta($postImgId, '_wp_attachment_image_alt', true) ?: get_the_title();
$url = get_post_type() === "social-media" ? get_field('call_to_action_url') : get_permalink();
$target = get_post_type() === "social-media" ? "target='_blank'" : "";
?>
<article class="tile tile--excerpt-mini">
	<a <?= $target; ?> href="<?= $url; ?>">
        <span class="excerpt-panel">
            <h3><?php the_title(); ?></h3>
            <p class="d-none d-xl-block"><?= wp_trim_words(get_the_content(), 13, '...') ?><strong> read article</strong></p>
            <p class="d-block d-xl-none">...<strong> read article</strong></p>
        </span>
		<img class="img-fluid" src="<?= $postImg[0]; ?>" alt="<?= $postImgAlt; ?>" />
	</a>
</article>