<?php 
$category = get_sub_field('category') ?? "";

if($category !== "") { 

    $args = array(
        'post_type'             => 'product',
        'post_status'           => 'publish',
        'ignore_sticky_posts'   => 1,
        'posts_per_page'        => '12',
        'tax_query'             => array(
            array(
                'taxonomy'      => 'product_cat',
                'field' => 'term_id', //This is optional, as it defaults to 'term_id'
                'terms'         => $category,
                'operator'      => 'IN' // Possible values are 'IN', 'NOT IN', 'AND'.
            ),
            array(
                'taxonomy'      => 'product_visibility',
                'field'         => 'slug',
                'terms'         => 'exclude-from-catalog', // Possibly 'exclude-from-search' too
                'operator'      => 'NOT IN'
            )
        )
    );

    $products = get_posts($args);


    $title = get_sub_field('title') ?? "";
    $link = get_sub_field("link") ?? "";
    $linkText = get_sub_field("link_text") ?? "";
    ?>
    <section class="section section--product-slider-supermarket sellers-slider" >
        <div class="container">
            <div class="row">
                <?php if ($title !== "") { ?><h1><?= $title; ?></h1><?php } ?>
                <div class="swiper-container swiper-sellers">
                    <div class="swiper-wrapper">
                        <?php
                        $productCounter = 0;
                        $productCount = count($products);
                        ?>
                        <?php foreach ($products as $product) { ?>

                            <?php

                            $productID = $product->ID;
                            $productLink = $product->guid;
                            $productImage = get_the_post_thumbnail_url($productID);
                            $productTitle = get_the_title($productID);

                            ?>

                            <?php if ($productCounter % 5 == 0) { ?>
                            <div class="swiper-slide <?= $productCounter ?>">
                            <?php } ?>

                                <a href="<?= $productLink; ?>">
                                    <img src="<?= $productImage; ?>" />
                                    <p><?= $productTitle; ?></p>
                                </a>
                                
                            <?php if ($productCounter % 5 == 4 || $productCounter == $productCount-1) { ?>
                            </div>
                            <?php } ?>

                            <?php
                            $productCounter++;
                            ?>
                        <?php } ?>
                        

                    </div>
                </div>
                <!-- Add Arrows -->
                <div class="banner-slider-buttons">
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </div>
        <?php if($linkText !== "") { ?>
            <a class="sellers-slider-cta" href="<?= $link ?>"><span class="cac-btn-graphic--alt btn-graphic--alt accent"><?= $linkText ?></span></a>
        <?php } ?>
    </section>
<?php } 