(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["woocommerce-delivery"],{

/***/ "./assets/scripts/woocommerce/delivery.js":
/*!************************************************!*\
  !*** ./assets/scripts/woocommerce/delivery.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($, jQuery) {var woocommerceDelivery = function woocommerceDelivery() {
  var postcodeIdentifier = '#deliveryPostcode';

  if ($('#billing_postcode').length === 1) {
    postcodeIdentifier = '#billing_postcode';
    $('.delivery_postcode').hide();
    $('#billing_postcode').val($('#deliveryPostcode').val());
  }

  var allowedDays = [];
  var leadTime = null;

  function updateAllowedDays() {
    if ($('.shipping.delivery_date').length) {
      var userPostcode = $(postcodeIdentifier).val();
      var postcodeSearchString = ",".concat(userPostcode.replace(/ /g, '').trim(), ",").toLowerCase();
      var deliveryData = jQuery.parseJSON(JSON.stringify($('.shipping.delivery_date').data('postcode-info')));
      allowedDays = [];

      for (var i = 0; i < deliveryData.length; i++) {
        var postcodeString = ",".concat(deliveryData[i].postcodes.replace(/ /g, '').trim(), ",").toLowerCase();

        if (postcodeString.search(postcodeSearchString) !== -1) {
          allowedDays = deliveryData[i].available_delivery_dates_by_day;
        }
      }

      if (allowedDays.length === 0) {
        // show no delivery
        $('#no-delivery-message').show();
        $('#deliveryDate').hide();
      } else {
        $('#no-delivery-message').hide();
        $('#deliveryDate').show();
      }
    }
  }

  $('input#deliveryDate').datepicker({
    beforeShowDay: function beforeShowDay(date) {
      var day = date.getDay().toString();
      var dateString = jQuery.datepicker.formatDate('dd/mm/yy', date);

      if (allowedDays.includes(day)) {
        return [ true && excludedDatesArray.indexOf(dateString) === -1];
      }

      return [false];
    }
  });
  $('body').on('change', '#billing_postcode', function () {
    if ($('#deliveryPostcode').length === 1) {
      $('#deliveryPostcode').val($('#billing_postcode').val());
      $('#deliveryPostcode').trigger('change');
    }
  });
  $('body').on('change', 'input#deliveryPostcode', function () {
    if ($('#billing_postcode').length === 1) {
      $('#billing_postcode').val($('#deliveryPostcode').val());
    }

    var data = {
      action: 'sh_set_delivery_postcode',
      delivery_postcode: $('input#deliveryPostcode').val()
    };
    jQuery.post(ajaxUrl, data, function () {});
  });
  $('body').on('change', 'input#deliveryDate', function () {
    var data = {
      action: 'sh_set_delivery_date',
      delivery_date: $('input#deliveryDate').val()
    };
    jQuery.post(ajaxUrl, data, function () {});
  });
  $(postcodeIdentifier).on('change', updateAllowedDays);
  $('body').on('updated_checkout', function () {
    if ($('#billing_postcode').length === 1) {
      postcodeIdentifier = '#billing_postcode';
      $('.delivery_postcode').hide();
    } // if ($('body').hasClass('woocommerce-checkout')) {
    // todo - integrate lead time


    var excludedDatesArray = [];
    var excludedDates = $('.shipping.delivery_date').length ? $('.shipping.delivery_date').data('excluded-delivery-dates') : []; // const leadTime = $('.delivery-date-form').data('delivery-lead-time');

    for (var i = 0; i < excludedDates.length; i++) {
      excludedDatesArray.push(excludedDates[i].date);
    }

    leadTime = new Date($('.shipping.delivery_date').data('lead-time'));
    updateAllowedDays();
    $(postcodeIdentifier).on('change', updateAllowedDays);
    $('input#deliveryDate').datepicker({
      beforeShowDay: function beforeShowDay(date) {
        var day = date.getDay().toString();
        var dateString = jQuery.datepicker.formatDate('dd/mm/yy', date);

        if (allowedDays.includes(day)) {
          return [ true && excludedDatesArray.indexOf(dateString) === -1 && date >= leadTime];
        }

        return [false];
      }
    });
  });
};

/* harmony default export */ __webpack_exports__["default"] = (woocommerceDelivery);
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "jquery"), __webpack_require__(/*! jquery */ "jquery")))

/***/ })

}]);
//# sourceMappingURL=woocommerce-delivery.js.map