const woocommerceDelivery = () => {
    let postcodeIdentifier = '#deliveryPostcode';

    if ($('#billing_postcode').length === 1) {
        postcodeIdentifier = '#billing_postcode';
        $('.delivery_postcode').hide();
        $('#billing_postcode').val($('#deliveryPostcode').val());
    }

    let allowedDays = [];
    let leadTime = null;

    function updateAllowedDays() {
        if ($('.shipping.delivery_date').length) {
            const userPostcode = $(postcodeIdentifier).val();
            const postcodeSearchString = `,${userPostcode.replace(/ /g, '').trim()},`.toLowerCase();

            const deliveryData = jQuery.parseJSON(JSON.stringify($('.shipping.delivery_date').data('postcode-info')));
            allowedDays = [];

            for (let i = 0; i < deliveryData.length; i++) {
                const postcodeString = `,${deliveryData[i].postcodes.replace(/ /g, '').trim()},`.toLowerCase();

                if (postcodeString.search(postcodeSearchString) !== -1) {
                    allowedDays = deliveryData[i].available_delivery_dates_by_day;
                }
            }

            if (allowedDays.length === 0) {
                // show no delivery
                $('#no-delivery-message').show();
                $('#deliveryDate').hide();
            } else {
                $('#no-delivery-message').hide();
                $('#deliveryDate').show();
            }
        }
    }

    $('input#deliveryDate').datepicker({
        beforeShowDay(date) {
            const day = date.getDay().toString();
            const dateString = jQuery.datepicker.formatDate('dd/mm/yy', date);
            if (allowedDays.includes(day)) {
                return [true && excludedDatesArray.indexOf(dateString) === -1];
            }
            return [false];
        },
    });

    $('body').on('change', '#billing_postcode', () => {
        if ($('#deliveryPostcode').length === 1) {
            $('#deliveryPostcode').val($('#billing_postcode').val());
            $('#deliveryPostcode').trigger('change');
        }
    });

    $('body').on('change', 'input#deliveryPostcode', () => {
        if ($('#billing_postcode').length === 1) {
            $('#billing_postcode').val($('#deliveryPostcode').val());
        }
        const data = {
            action: 'sh_set_delivery_postcode',
            delivery_postcode: $('input#deliveryPostcode').val(),
        };
        jQuery.post(ajaxUrl, data, () => {});
    });

    $('body').on('change', 'input#deliveryDate', () => {
        const data = {
            action: 'sh_set_delivery_date',
            delivery_date: $('input#deliveryDate').val(),
        };
        jQuery.post(ajaxUrl, data, () => {});
    });

    $(postcodeIdentifier).on('change', updateAllowedDays);

    $('body').on('updated_checkout', () => {
        if ($('#billing_postcode').length === 1) {
            postcodeIdentifier = '#billing_postcode';
            $('.delivery_postcode').hide();
        }
        // if ($('body').hasClass('woocommerce-checkout')) {
        // todo - integrate lead time
        const excludedDatesArray = [];
        const excludedDates = $('.shipping.delivery_date').length ? $('.shipping.delivery_date').data('excluded-delivery-dates') : [];
        // const leadTime = $('.delivery-date-form').data('delivery-lead-time');

        for (let i = 0; i < excludedDates.length; i++) {
            excludedDatesArray.push(excludedDates[i].date);
        }

        leadTime = new Date($('.shipping.delivery_date').data('lead-time'));

        updateAllowedDays();

        $(postcodeIdentifier).on('change', updateAllowedDays);

        $('input#deliveryDate').datepicker({
            beforeShowDay(date) {
                const day = date.getDay().toString();
                const dateString = jQuery.datepicker.formatDate('dd/mm/yy', date);
                if (allowedDays.includes(day)) {
                    return [true && excludedDatesArray.indexOf(dateString) === -1 && date >= leadTime];
                }
                return [false];
            },
        });
    });
};

export default woocommerceDelivery;
