<?php
$categories = get_field('category_menu', 'options');
if($categories) {
?>
    <section class="section--nav section--brand-nav">
        <div class="container">
            <div class="row">
                <div class="col-8 col-lg-10">
                    <h2 class="accent title-nav"><a href="/product-category/full-range/">Christmas <br/><span>& Hogmanay</span></a></h2>
                    <nav class="swiper-container swiper-nav-horizontal-scroll">
                        <ul class="list-inline list-category swiper-wrapper">
                            <?php foreach($categories as $category) { 
                                $term = get_term_by('id', $category, 'product_cat'); ?>
                                <li class="swiper-slide"><a href="<?= get_term_link($term); ?>"><?= $term->name; ?></a></li>
                            <?php } ?>
                        </ul>
                    </nav>
                </div>
                <div class="col-4 col-lg-2">
                    <div class="swiper-buttons">
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                    <div class="checkout">
                        <a class="header-cart-christmas" href="/checkout" title="View your shopping cart">
                            <span class="accent">Checkout</span>
                            <div class="cart-contents-wrapper"></div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php // if(is_product_category()) { ?>
        <!-- <div class="white-overlay"></div> -->
    <?php // } ?>
<?php }