<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     2.0.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header('shop');

if(is_shop()) {
    get_template_part('templates/parts/banner'); 
    get_template_part('templates/sections/flex-instructions');     
}

/**
 * woocommerce_before_main_content hook.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
// do_action('woocommerce_before_main_content');

// get_template_part('templates/parts/product-search');
?>
<div class="loaders"></div>
<?php 
if (is_shop()) {
    $thumbnail_id = get_field('main_shop_page_background_image', 'option');
    $bgImage = $thumbnail_id ? wp_get_attachment_url($thumbnail_id, 'full') : '';
}
$term = get_queried_object();
?>

<div class="<?php if(is_shop()) { ?>shop-wrapper<?php } else { ?>category-wrapper<?php } ?>" <?php if(isset($bgImage)) { ?>style="background-image: url('<?= $bgImage; ?>');"<?php } ?>>
    <header class="woocommerce-products-header">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-8 offset-lg-2">
                    <?php if(is_shop()) { ?>
                        <h1 class="accent"><?php the_field('shop_title', 'option'); ?></h1>
                        <h2><?php the_field('shop_subtitle', 'option'); ?></h2>  
                    <?php } else if (get_field('category_title', $term)) { ?>
                        <h2 class="accent"><?php the_field('category_title', $term); ?></h2>
                        <h1><?= get_queried_object()->name; ?></h1>  
                    <?php } else { ?>
                        <h1><?= get_queried_object()->name; ?></h1>  
                    <?php } ?>
                </div>
            </div>
        </div>
    </header>

    <div class="container container--fluid-until-lg">
        <div class="row">

            <div class="col-lg-12 click-collect-products">
                <script>var ajaxUrl = "<?= admin_url('admin-ajax.php'); ?>";</script>
                <?php 
                if(is_shop() && have_rows('sections', 'option')) {
                    while ( have_rows('sections', 'option') ) {
                        the_row();
                        if(get_row_layout() == 'flex-product-category-row') {
                            get_template_part('templates/sections/flex-product-category-row'); 
                        }
                    } 
                } else { 
                    if (have_posts()) { 
                        /**
                         * woocommerce_before_shop_loop hook.
                         *
                         * @hooked wc_print_notices - 10
                         * @hooked woocommerce_result_count - 20
                         * @hooked woocommerce_catalog_ordering - 30
                         */
                       
                        woocommerce_product_loop_start(); 
                        woocommerce_product_subcategories(); 
                        
                        while (have_posts()) {
                            the_post();
                            /**
                             * woocommerce_shop_loop hook.
                             *
                             * @hooked WC_Structured_Data::generate_product_data() - 10
                             */
                            do_action('woocommerce_shop_loop');
                            wc_get_template_part('content', 'product');
                        }

                        woocommerce_product_loop_end(); 
                        ?>

                        <div class="row">
                            <div class="col-md-12"> 
                                <?php
                                global $wp_query;
                                isset($wp_query->query_vars['product_cat']) ? $category = $wp_query->query_vars['product_cat'] : $category = 'click-collect';
                                isset($wp_query->query_vars['product_tag']) ? $tag = $wp_query->query_vars['product_tag'] : $tag = '';
                                echo '<div data-category="' . $category . '" data-tag="' . $tag . '" data-search="' . get_search_query() . '" data-page="1" class="loadMore"></div>'; 
                                ?>
                            </div>
                        </div>
                        <?php
                        /**
                         * woocommerce_after_shop_loop hook.
                         *
                         * @hooked woocommerce_pagination - 10
                         */
                        do_action('woocommerce_after_shop_loop');
                        
                    } elseif (!woocommerce_product_subcategories(['before' => woocommerce_product_loop_start(false), 'after' => woocommerce_product_loop_end(false)])) {

                        /**
                         * woocommerce_no_products_found hook.
                         *
                         * @hooked wc_no_products_found - 10
                         */
                        do_action('woocommerce_no_products_found');
                        
                    } 
                    /**
                     * woocommerce_after_main_content hook.
                     *
                     * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                     */
                    do_action('woocommerce_after_main_content');
                }
                ?>

            </div>
        </div>
    </div>
</div>
<?php get_footer('shop'); ?>
