<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.2.0
 */

global $wpdb;

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="woocommerce-order">

    <?php if ($order) : ?>

        <?php if ($order->has_status('failed')) : ?>

        <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php _e('Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce'); ?></p>

        <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
            <a href="<?php echo esc_url($order->get_checkout_payment_url()); ?>"
               class="button pay"><?php _e('Pay', 'woocommerce') ?></a>
            <?php if (is_user_logged_in()) : ?>
                <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>"
                   class="button pay"><?php _e('My account', 'woocommerce'); ?></a>
            <?php endif; ?>
        </p>

    <?php else : ?>

        <p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters('woocommerce_thankyou_order_received_text', __('Thank you. Your order has been received.', 'woocommerce'), $order); ?></p>

        <ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

            <li class="woocommerce-order-overview__order order">
                <?php _e('Order number:', 'woocommerce'); ?>
                <strong><?php echo $order->get_order_number(); ?></strong>
            </li>

            <li class="woocommerce-order-overview__date date">
                <?php
                $shippingDetails = Blue2\Scruffy\Controllers\WoocommerceController::getShippingDetails($order);
                $isDelivery = Blue2\Scruffy\Controllers\WoocommerceController::getOrderType($order) == 'ship';
                if (!$isDelivery) {
                    $order_itemmeta = $wpdb->prefix . 'woocommerce_order_itemmeta';
                    $order_items = $wpdb->prefix . 'woocommerce_order_items';
                    $timeResults = $wpdb->get_results("
                SELECT p.meta_value
                            FROM {$order_itemmeta} AS p
                            JOIN {$order_items} AS psi ON psi.order_item_id = p.order_item_id
                            WHERE p.meta_key = '_pickup_date'
                            AND psi.order_id = {$order->get_id()}
                        ", ARRAY_N);

                    $time = date_i18n(wc_time_format(), $timeResults[0][0]);
                    $timeEnd = date_i18n(wc_time_format(), $timeResults[0][0] + 7200);

                    $date = date_i18n(wc_date_format(), $timeResults[0][0]);
                    $dateString = str_replace("-", "", $timeResults[0][0]);
                    $dateWords = date('l jS F Y', strtotime($dateString));
                    ?>

                    <strong>Collection date: <span class="orange-letters"><?= $dateWords; ?></span></strong>
                    <strong>Collection place: <span class="orange-letters"><a
                                        href="https://christmas.thescottishbutcher.com/how-to-order/#deliveryInfo"
                                        target="_blank"><?= $shippingDetails['Pickup Location']; ?></a></span></strong>


                <?php } else {
                    $deliveryDate = get_post_meta($order->get_id(), 'deliveryDate'); ?>
                    <strong>Delivery date: <span class="orange-letters"><?= $deliveryDate[0]; ?></span></strong>
                <?php } ?>
            </li>

            <?php if (is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email()) : ?>
                <li class="woocommerce-order-overview__email email">
                    <?php _e('Email:', 'woocommerce'); ?>
                    <strong><?php echo $order->get_billing_email(); ?></strong>
                </li>
            <?php endif; ?>

            <li class="woocommerce-order-overview__total total">
                <?php _e('Price:', 'woocommerce'); ?>
                <strong><?php echo $order->get_formatted_order_total(); ?></strong>
            </li>

            <?php if ($order->get_payment_method_title()) : ?>
                <li class="woocommerce-order-overview__payment-method method">
                    <?php _e('Payment method:', 'woocommerce'); ?>
                    <strong><?php echo wp_kses_post($order->get_payment_method_title()); ?></strong>
                </li>
            <?php endif; ?>

        </ul>
        <script>
            gtag('event', 'purchase', {
                "transaction_id": "<?= $order->get_order_number(); ?>",
                "affiliation": "<?= $shippingDetails['Pickup Location']; ?>",
                "value": <?= $order->get_total(); ?>,
                "currency": "GBP",
                "tax": 0,
                "shipping": 0,
                "items": [
                    <?php
                    foreach($order->get_items() as $itemKey => $item) {
                    $product = $item->get_product();
                    ?>
                    {
                        "id": "<?= $product->get_sku(); ?>",
                        "name": "<?= $product->get_name(); ?>",
                        "quantity": <?= $item->get_quantity(); ?>,
                        "price": '<?= $item->get_total(); ?>'
                    },
                    <?php } ?>
                ]
            });
        </script>
    <?php endif; ?>

    <?php
    do_action('woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id());

    if (get_field('content_for_price_disclaimer', 'option')) {
        the_field('content_for_price_disclaimer', 'option');
    }

    // do_action( 'woocommerce_thankyou', $order->get_id() );
    Blue2\Scruffy\Controllers\WoocommerceController::b2ViewOrder($order);
    ?>

    <?php else : ?>

        <p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters('woocommerce_thankyou_order_received_text', __('Thank you. Your order has been received.', 'woocommerce'), null); ?></p>

    <?php endif; ?>

</div>