<?php
$terms = wp_get_post_terms( get_the_ID(), 'department');
$date = new DateTime(get_field('closing_date', false, false));
?>
<section class="section section-vacancies-archive section-vacancies-archive__single">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php
                if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                }
                ?>
            </div>
            <div class="col-lg-8">
                <h1><?= get_the_title(); ?>
                    <span class="location">Location: <?= get_field('location') . '</span><span>Closing Date: ' . date_format($date, 'l jS \of F' ); ?></span>
                </h1>
                <?php the_content(); ?>
                <a class="vacancies" href="/vacancies" ><i class="fas fa-arrow-left"></i> Return to all vacancies</a>
            </div>
            <div class="col-lg-4">
                <div class="application-form">
                    <strong>Application form</strong>
                    <?= do_shortcode('[contact-form-7 title="Job Application"]') ?>
                </div>
            </div>
        </div>
    </div>
</section>
