<?php
$image = get_post_thumbnail_id() ? wp_get_attachment_image_src(get_post_thumbnail_id(), 'portrait-advert') : [get_template_directory_uri() . "/dist/images/default-portrait-advert-800-1407.jpg"];

$product = get_field('favourite_product');

global $post;
$post = $product;
setup_postdata($post); 
$productTitle = $product ? get_the_title() : '';
$productImageId = $product ? get_post_thumbnail_id() : '';
$squareImage = $product && get_field('square_image') ? wp_get_attachment_image_src(get_field('square_image'), 'award-square') : '';
$squareImage = $squareImage == '' && $product ? wp_get_attachment_image_src($productImageId, 'award-square') : $squareImage;
$productUrl = $product ? get_the_permalink() : '';
wp_reset_postdata();


$terms = wp_get_post_terms(get_the_ID(), 'area-of-expertise');
$listOfTerms = "";
foreach($terms as $term) {
    $listOfTerms .= $term->slug . " ";
}
$name = get_the_title();
$position = get_field('position');
$content = get_the_content();
$email = get_field('email_address');
$linkedin = get_field('linked_in_url');
$modalImage = get_field('modal_image') ? wp_get_attachment_image_src(get_field('modal_image'), 'portrait-advert') : $image;
?>
<div class="col-6 col-md-4 col-lg-3 mix <?= $listOfTerms; ?>">
    <figure class="tile tile--person">
        <?php if($product) { ?>
            <a class="highlight" target="_blank" href="<?= $productUrl; ?>">
                <img class="img-fluid" src="<?= $squareImage[0]; ?>" alt="Favourite product <?= $productTitle; ?>">
            </a>
        <?php } ?>
        <?php if(!empty($content)) { ?>
            <a href="" data-toggle="modal" data-target="#personBioModal" class="modal-btn" data-content="<?= $content; ?>" data-title="<?= $name; ?>"
            data-position="<?= $position; ?>" data-image="<?= $modalImage[0]; ?>" data-productimage="<?= $squareImage[0]; ?>" data-productalt="<?= $productTitle; ?>"
            data-producturl="<?= $productUrl; ?>" data-email="<?= $email; ?>" data-linkedin="<?= $linkedin; ?>">
            <span class="cta btn-graphic">About <?= $name; ?></span>
        <?php } ?>   
            <img class="img-fluid" src="<?= $image[0]; ?>" alt="<?= $name; ?>" />
            <figcaption>
                <h2><?= $name ?></h2>
                <?php if($position) { ?>
                    <h3><?= $position; ?></h3>
                <?php } ?>
            </figcaption>
        <?php if(!empty($content)) { ?>
            </a>
        <?php } ?>
        <span class="ctas">
            <?php if($email) { ?>
                <a class="removeFadeOut" href="mailto:<?= $email; ?>">Get in touch</a>
            <?php } ?>

            <?php if(!empty(get_the_content())) { ?>
                <a href="" data-toggle="modal" data-target="#personBioModal" class="modal-btn" data-content="<?= $content; ?>" data-title="<?= $name; ?>"
                    data-position="<?= $position; ?>" data-image="<?= $image[0]; ?>" data-productImage="<?= $squareImage[0]; ?>" data-productAlt="<?= $productTitle; ?>"
                    data-productUrl="<?= $productUrl; ?>" data-email="<?= $email; ?>" data-linkedin="<?= $linkedin; ?>">
                    View bio</a>
            <?php } ?>
        </span>
    </figure>      
</div>