/* global ajaxUrl */

const checkIfEmpty = function() {
    if ($('.cart_item').length === 0) {
        $('.empty-cart').show();
    } else {
        $('.empty-cart').hide();
    }
};

const checkIfAllAvailable = function() {
    if ($('tr.cart_item.not-available').length > 0) {
        $('.checkout-button').addClass('disable');
    }
};

const qtyUpdates = function() {
    $('form.checkout').on('click', 'input.qty', () => {
        const data = {
            action: 'update_order_review',
            security: wc_checkout_params.update_order_review_nonce,
            post_data: $('form.checkout').serialize()
        };
        jQuery.post(ajaxUrl, data, () => {
            $('body').trigger('update_checkout');
        });
    });
};

const formatter = new Intl.NumberFormat('en-UK', {
    style: 'currency',
    currency: 'GBP',
    minimumFractionDigits: 2
});

function animateSpinner(el, animation, complete) {
    if (el.data('animating')) {
        el.removeClass(el.data('animating')).data('animating', null);
        el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
    }
    el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
    el.data('animationTimeout', setTimeout(function() {
        animation === 'remove' && el.remove();
        complete && complete();
    }, parseFloat(el.css('animation-duration')) * 1000));
}

function addSpinner(el, static_pos) {
    let spinner = el.children('.spinner');
    if (spinner.length && !spinner.hasClass('spinner-remove')) {
        return null;
    }
    !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
    animateSpinner(spinner, 'add');
}

function removeSpinner(el, complete) {
    const spinner = el.children('.spinner');
    spinner.length && animateSpinner(spinner, 'remove', complete);
}

const addApproxHTML = function() {
    const form = $(this).closest('form.cart')[0];
    const select = $(form).find('select');
    const valueOfSelect = $(select).find(':selected')
        .val();
    console.log(valueOfSelect);
    $('.approx-price').remove();
    if (valueOfSelect === '') {
        $('.approx-price').remove();
    } else if ($(form).hasClass('price-approx')) {
        $(form).find('.single_variation_wrap')
            .append('<span class="approx-price approx-price-variations">Approx.</span>');
    }
};

const showPriceAfterRefresh = function() {
    $('.checkout-button').on('click', function() {
        gtag('event', 'Checkout', { 'event_category':'Shopping cart', 'event_label': 'proceed to checkout' });
    });
    $('.remove_from_cart_button').on('click', function() {
        gtag('event', 'remove item', { 'event_category':'Shopping cart', 'event_label': 'remove from shopping cart' });
    });

    $(() => {
        $('.variations_form').each((index, form) => {
            const addToCartButton = $(form).find('button')
                .attr('disabled', 'disabled');
            const select = $(form).find('select');

            $(select).on('change', function() {
                $(form).find('.woocommerce-variation-price')
                    .remove();
                $(addToCartButton).removeAttr('disabled');
                const valueOfSelect = $(this).find(':selected')
                    .val();
                const variationObjects = JSON.parse($(form).attr('data-product_variations'));
                let finalPrice = '';
                jQuery.each(variationObjects, (i, val) => {
                    if (val.attributes.attribute_size === valueOfSelect) {
                        finalPrice = val.display_price;
                    }
                });
                $('.approx-price').remove();
                if (valueOfSelect === '') {
                    $('.approx-price').remove();
                } else if ($(form).hasClass('price-approx')) {
                    $(form).find('.single_variation')
                        .prepend('<div class="woocommerce-variation-price"><span class="approx-price">Approx.</span><span class="price"><span class="woocommerce-Price-amount amount">' + formatter.format(finalPrice) + '</span></span> </div>');
                } else {
                    $(form).find('.single_variation')
                        .prepend('<div class="woocommerce-variation-price"><span class="price"><span class="woocommerce-Price-amount amount">' + formatter.format(finalPrice) + '</span></span> </div>');
                }
            });
        });
    });
};

const calculatePriceAfterRefresh = function() {
    $(() => {
        const form = $(this).closest('form.cart')[0];
        const price = $(this).closest('table')
            .attr('data-price');
        const weight = parseFloat($(form).find('.amount_needed')
            .val());
        let calculatedPrice = (price / 1000) * weight;
        calculatedPrice = Math.round(calculatedPrice * 100) / 100;

        $(form).find('.amount')
            .html(formatter.format(calculatedPrice));
    });
};

// Fragment the sidebar cart, to update it every time it is changed
const changeSidebarCart = function() {
    $(document.body).trigger('update_checkout');
    checkIfEmpty();
};

// Change amount of people fed depending on the inputted weight
const weightToPeople = function() {
    const form = $(this).closest('form.cart')[0];
    const weight = parseFloat($(form)
        .find('.amount_needed')
        .val()
    );
    const weightForOne = $(form).find('table')
        .data('feedone');
    const people = weight / weightForOne;
    const peopleFed = parseInt(people, 10);
    $(form).find('.no_people_fed')
        .val(peopleFed);
};

// Change amount of weight shown depending on inputted amount of people
const peopleToWeight = function() {
    const form = $(this).closest('form.cart')[0];
    const people = parseFloat($(form).find('.no_people_fed')
        .val());
    const weightForOne = $(form).find('table')
        .data('feedone');
    const weight = people * weightForOne;
    const weightNeeded = parseInt(weight, 10);
    $(form).find('.amount_needed')
        .val(weightNeeded);
    $(this).closest('form.cart')
        .trigger('wc-measurement-price-calculator-update');
    $(form).trigger('wc-measurement-price-calculator-update');
};
const bindEvents = () => {
    $('.amount_needed').on('change keyup', weightToPeople);
    $('.no_people_fed').on('change keyup', peopleToWeight);
    $('#size').on('change', addApproxHTML);

    $('.no_people_fed').on('change keyup', calculatePriceAfterRefresh);
    $('.amount_needed').on('change keyup', calculatePriceAfterRefresh);

    $(() => {
        $('form.cart').each((index, form) => {
            const weightForOne = $(form).find('table')
                .data('feedone');
            const totalPrice = $(form).find('table')
                .data('price');
            const priceForOne = (totalPrice / 1000) * weightForOne;
            const newPrice = Math.round(priceForOne * 100) / 100;
            $(form).find('.product_price')
                .html('<span class="amount">' + formatter.format(newPrice) + '</span>');
        });
    });


    $(() => {
        $('form.cart').each((index, form) => {
            const weightForOne = $(form).find('table')
                .data('feedone');
            const minFeed = $(form).find('table')
                .data('minfeed');
            const minWeight = weightForOne * minFeed;
            $(form).find('#weight_needed')
                .val(minWeight);
            $(form).find('#no_people_fed')
                .val(minFeed);
            $(form).trigger('wc-measurement-price-calculator-update');
        });
    });


    $('.form-ajax').submit(e => {
        let variables = String($(e.target).serialize());
        const id = $(e.target).find('button')
            .data('productid');
        variables = variables.concat('&add-to-cart=');
        variables = variables.concat(id);
        $.post('', variables, () => {
            $('body').trigger('added_to_cart');
        });
        checkIfEmpty();
        checkIfAllAvailable();
        return false;
    });
};
let updateProducts = false;

const ajaxRefresh = function() {
    if (updateProducts) {
        const page = $('.loadMore').attr('data-page');
        const category = $('.loadMore').attr('data-category');
        const tag = $('.loadMore').attr('data-tag');
        const search = $('.loadMore').attr('data-search');

        $.ajax({
            type: 'POST',
            url: ajaxUrl,
            dataType: 'html',
            data: {
                action: 'getAjaxPosts',
                pageNumber: page,
                category,
                tag,
                search
            },
            success: response => {
                $('.products').html(response);
                bindEvents();
                showPriceAfterRefresh();
                calculatePriceAfterRefresh();
                $('.amount_needed').on('change keyup', () => {
                    weightToPeople();
                });
                $('.no_people_fed').on('change keyup', () => {
                    peopleToWeight();
                });
            },
            error: () => {
                alert('Sorry, there was a problem!');
            },
            complete: () => {
            }
        });
        updateProducts = false;
    }
};

const fragmentRefresh = function() {
    $(document.body).trigger('wc_fragment_refresh');
};

const woocommerce = () => {
    $('form.checkout').on('click', 'input.qty', () => {
        const data = {
            action: 'update_order_review',
            security: wc_checkout_params.update_order_review_nonce,
            post_data: $('form.checkout').serialize()
        };
        jQuery.post(ajaxUrl, data, () => {
            $('body').trigger('update_checkout');
        });
    });


    $('body').on('added_to_cart removed_from_cart', changeSidebarCart);

    $('body').on('update_cart', ajaxRefresh);
    $('body').on('change', '.pickup-location-lookup', () => {
        updateProducts = true;
    });


    $('body').on('update_checkout', ajaxRefresh);
    $('body').on('update_checkout', fragmentRefresh);

    $('body').on('added_to_cart', () => {
        $('.empty-cart').hide();
        if ($('.woocommerce-checkout').length === 0) {
            $('.sidebar-cart').append('<form class="checkout woocommerce-checkout"><table class="shop_table woocommerce-checkout-review-order-table"></table></form>');
            $('.empty-cart').hide();
        }
    });

    $('body').on('removed_from_cart', () => {
        if ($('.cart_item').length === 1) {
            $('.empty-cart').show();
        }
    });

    $('body.archive').trigger('update_checkout');
    bindEvents();
    checkIfEmpty();
    checkIfAllAvailable();
    qtyUpdates();

    $('body').on('click', '.checkout-button', e => {
        if ($('.pickup-location-lookup').val() === '') {
            e.preventDefault();
            $('.select2-selection').addClass('border-warning');
            $('.checkout-button').addClass('disabled');
            $('html, body').animate({
                scrollTop: $('.pickup_location').offset().top
            }, 2000);
        }
        return;
    });

    // $('.qty').on('change', event => {
    //     const qty = $(event.target).val();
    //     console.log(qty);
    //     const form = $(event.target).closest('form');
    //     const price = form.attr('data-price');
    //     console.log(price);
    //     const totalPrice = price * qty;
    //     console.log(totalPrice);
    //     form.find('woocommerce-Price-amount').append(totalPrice);
    //     console.log(form.find('woocommerce-Price-amount').append(totalPrice));
    // });

    if ($('.woocommerce-error').length > 0) {
        // $('.woocommerce-error').css('display', 'none');
    }

    let hasReachedBottom = false;
    let isUpdating = false;
    let bottomOffset;

    $(window).on('scroll', () => {
        if (window.innerWidth <= 992) {
            bottomOffset = 3000;
        } else {
            bottomOffset = 1500;
        }

        if ($(document).scrollTop() > ($(document).height() - bottomOffset) && $('.end').length < 1) {
            hasReachedBottom = true;
            let page = $('.loadMore').attr('data-page');
            const category = $('.loadMore').attr('data-category');
            const tag = $('.loadMore').attr('data-tag');
            const search = $('.loadMore').attr('data-search');

            if (hasReachedBottom && !isUpdating) {
                isUpdating = true;
                $.ajax({
                    url: ajaxUrl,
                    data: {
                        action: 'loadMorePosts',
                        pageNumber: page,
                        category,
                        tag,
                        search
                    },
                    type: 'POST',
                    beforeSend: () => {
                        addSpinner($('.products'));
                        console.log('sending');
                    },
                    success: data => {
                        if (data) {
                            page++;
                            $('.products').append(data);
                            qtyUpdates();
                            bindEvents();
                            showPriceAfterRefresh();
                            calculatePriceAfterRefresh();
                            $('.amount_needed').on('change keyup', () => {
                                weightToPeople();
                            });
                            $('.no_people_fed').on('change keyup', () => {
                                peopleToWeight();
                            });
                            window.doingAjax = false;
                            return false;
                        }
                    },
                    complete: () => {
                        $('.loadMore').attr('data-page', page);
                        isUpdating = false;
                        removeSpinner($('.products'));
                    }
                });
            }
            return false;
        }
    });

    // Show product modal after add to cart
    if ($('#additionalProductModal').length > 0) {
        $('#additionalProductModal').modal('show');
    }
};

$(document).scroll(() => {
    $('.hasDatepicker').blur();
    $('.hasDatepicker').datepicker('hide');
});

$('.drawerToggle').click(() => {
    $('.drawer').toggleClass('open');
});

export default woocommerce;
