<div class="summary">
    <h1><?php the_title(); ?></h1>

    <?php if(get_field('product_sub_line')) { ?>
        <h3 class="subtitle"><?php the_field('product_sub_line'); ?></h3>
    <?php } ?>

    <?php if(get_field('relevant_stores')) { ?>
        <div class="supermarket-stores-wrapper">
            <div class="align-self-top pt-md-3">
                <a class="marker-url" onclick="gtag('event', 'click stockist finder', {'event_category':'supermarket product page', 'event_label':'find near me'});" target="_blank" href="/where-to-buy">Where to buy:
                    <span>
                        <i class="fas fa-map-marker-alt"></i> Find near me
                    </span>
                </a>
            </div>
            <div class="d-flex flex-wrap store-row align-items-stretch">
                <?php 
                foreach(get_field('relevant_stores') as $store) { 
                    $productImageId = get_field('image', $store);
                    $url = get_field('store_url', $store);
                    $productImage = wp_get_attachment_image_src($productImageId, 'medium') ?: '';
                    if($productImage) {
                        $productImageAlt = get_post_meta($productImageId, '_wp_attachment_image_alt', true) ?: get_the_title();
                        ?>
                        <div class="flex-fill align-self-center">
                            <?php if($url) { ?>
                                <a href="<?= $url; ?>" target="_blank">
                            <?php } ?>
                            <img class="img-fluid store-img" src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>"/>
                            <?php if($url) { ?>
                                </a>
                            <?php } ?>
                        </div>
                    <?php 
                    } 
                }
                ?>
            </div>
        </div>
    <?php } ?>
</div>