<?php
/**
 * Show messages
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/notices/success.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     1.6.4
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// if (!$messages) {
//     return;
// }

if (is_product()) {
    ?>

    <div class="modal fade" id="additionalProductModal" tabindex="-1" role="dialog"
         aria-labelledby="additionalProductTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12 col-lg-5 pr-lg-0">
                            <?php $image = get_the_post_thumbnail_url(get_the_ID(), 'fullwidth'); ?>
                            <div class="main-image">
                                <img src="<?= $image; ?>" class="img-fluid"/>
                            </div>
                        </div>
                        <div class="col-12 col-lg-7">
                            <h5 class="modal-title accent" id="additionalProductTitle">Excellent</h5>
                            <p class="basket-message"><i class="far fa-check-circle"></i><span><?= the_title(); ?></span> has been added to your cart.</p>
                            
                            <div class="modal-buttons">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Continue Shopping</button>
                                <a href="<?= wc_get_checkout_url() ?>" class="btn btn-primary">Checkout</a>
                            </div>
                        </div>
                    </div>

                    <?php if(get_field('relevant_products')) { ?>
                        <div class="row">
                            <div class="col-12">
                                <h6 class="accent">Goes great with</h6>
                            </div>

                            <?php
                            $products = get_field('relevant_products');
                            $count = 0;
                            foreach($products as $postId) {
                                $post_object = get_post($postId);    
                                $image = get_the_post_thumbnail_url($postId, 'fullwidth');
                                $count++;
                                if($count < 5) {
                                ?>
                                    <div class="col-12 col-lg-6">
                                        <div class="great-with">
                                            <img src="<?= $image; ?>" class="img-fluid"/>  
                                            <a href="<?php echo get_permalink($post_object->ID); ?>">
                                                <?php echo get_the_title($post_object->ID); ?>
                                                <span class="btn btn-graphic--alt accent">Add to Order</span>
                                            </a>
                                        </div>
                                    </div>
                                <?php
                                }
                            }
                            ?>
                        </div>
                    <?php } ?>
                  
                   
                    <div class="container-fluid">
                        <div class="row">
                            <?php
                            global $post;
                            while (have_rows('modal_information_products')) {
                                the_row();
                                $post = get_sub_field('product');
                                get_template_part('templates/parts/related-cats');
                                wp_reset_postdata();
                            } ?>
                        </div>
                    </div>
                     
                </div>
            </div>
        </div>
    </div>
    <?php
} else {
    ?>
    <?php foreach ($messages as $message) : ?>
        <div class="woocommerce-message"><?= wp_kses_post($message); ?></div>
    <?php endforeach;
} ?>
