<?php
$thumbnailId = isset($rowAmount) && $rowAmount === 'one' && get_field('long_image', $term) ? get_field('long_image', $term) : 
    get_term_meta( $term->term_id, 'thumbnail_id', true );
$size = isset($rowAmount) && $rowAmount === 'one' ? 'thin-tile' : 'product-square';
$image = $thumbnailId ? wp_get_attachment_image_src($thumbnailId, $size) : ['https://d1ssu070pg2v9i.cloudfront.net/pex/simonhowie_christmas/2019/08/21104038/simonlogo.png'];
?>

<figure class="tile tile--category tile--img-hover">

    <a href="<?= get_term_link( $term ); ?>">
        <img class="img-fluid" src="<?= $image[0]; ?>" alt="<?= $term->name; ?>" />

        <figcaption class="tile--category--text">
            <span class="cta btn-graphic--alt accent"><?= $term->name; ?></span>

            <div class="category-description">
                <?php echo wp_trim_words(category_description( $term->term_id ), 15); ?> 
            </div>

            <div class="category-text">
                <?php 
                $viewAll = get_field('view_all_text', $term) ?: 'View all our ' . $term->name . ' products';
                echo $viewAll; 
                ?>
            </div>
        </figcaption>
    </a>

</figure>