import Swiper from 'swiper';
import 'swiper/dist/css/swiper.min.css';

const headerSwiper = () => {
    new Swiper ('.swiper-nav-supermarket', {
        loop: true,
        slidesPerView: 9,
        spaceBetween: 10,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        breakpoints:{
            320: {
                slidesPerView: 3,
                spaceBetween: 10
            },
            640: {
                slidesPerView: 3,
                spaceBetween: 10
            },
            992: {
                slidesPerView: 5,
                spaceBetween: 10
            },
            1200: {
                slidesPerView: 7,
                spaceBetween: 10
            }
        }
    });
    new Swiper ('.swiper-nav-horizontal-scroll', {
        loop: false,
        slidesPerView: 'auto',
        cssWidthAndHeight: true,
        visibilityFullFit: true,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
    });
    new Swiper ('.swiper-collections', {
        loop: false,
        slidesPerView: 'auto',
        cssWidthAndHeight: true,
        visibilityFullFit: true,
        navigation: {
            nextEl: '.collection-next',
            prevEl: '.collection-prev',
        },
    });
};
export default headerSwiper;
