<?php
/**
 * View Order
 *
 * Shows the details of a particular order on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/view-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wpdb;

$status = '';
if(wc_get_order_status_name( $order->get_status() ) === 'Cancelled') {
    $status = 'Processing';
} else {
    $status = wc_get_order_status_name( $order->get_status() );
}

?>
<p><?php
	/* translators: 1: order number 2: order date 3: order status */
	printf(
		__( 'Order #%1$s was placed on %2$s and is currently %3$s.', 'woocommerce' ),
		'<mark class="order-number">' . $order->get_order_number() . '</mark>',
		'<mark class="order-date">' . wc_format_datetime( $order->get_date_created() ) . '</mark>',
		'<mark class="order-status">' . $status . '</mark>'
	);
?></p>
<?php
if (!$isDelivery) {
    $order_itemmeta = $wpdb->prefix . 'woocommerce_order_itemmeta';
    $order_items = $wpdb->prefix . 'woocommerce_order_items';
    $timeResults = $wpdb->get_results("
SELECT p.meta_value
			FROM {$order_itemmeta} AS p
			JOIN {$order_items} AS psi ON psi.order_item_id = p.order_item_id
			WHERE p.meta_key = '_pickup_date'
			AND psi.order_id = {$order->get_id()}
		", ARRAY_N);

    $time = date_i18n(wc_time_format(), $timeResults[0][0]);
    $timeEnd = date_i18n(wc_time_format(), $timeResults[0][0] + 7200);

    $date = date_i18n(wc_date_format(), $timeResults[0][0]);
	$dateString = str_replace("-", "", $timeResults[0][0]);
	$dateWords = date('l jS F Y', strtotime($dateString));
?>

<p><strong>Collection date: <span class="orange-letters"><?= $dateWords; ?></span></strong></p>

<?php } else {
    $deliveryDate = get_post_meta($order->get_id(), 'deliveryDate'); ?>
    <p><strong>Delivery date: <span class="orange-letters"><?= $deliveryDate[0]; ?></span></strong></p>
<?php } ?>
<?php if ( $notes = $order->get_customer_order_notes() ) : ?>
	<h2><?php _e( 'Order updates', 'woocommerce' ); ?></h2>
	<ol class="woocommerce-OrderUpdates commentlist notes">
		<?php foreach ( $notes as $note ) : ?>
		<li class="woocommerce-OrderUpdate comment note">
			<div class="woocommerce-OrderUpdate-inner comment_container">
				<div class="woocommerce-OrderUpdate-text comment-text">
					<p class="woocommerce-OrderUpdate-meta meta"><?php echo date_i18n( __( 'l jS \o\f F Y, h:ia', 'woocommerce' ), strtotime( $note->comment_date ) ); ?></p>
					<div class="woocommerce-OrderUpdate-description description">
						<?php echo wpautop( wptexturize( $note->comment_content ) ); ?>
					</div>
	  				<div class="clear"></div>
	  			</div>
				<div class="clear"></div>
			</div>
		</li>
		<?php endforeach; ?>
	</ol>
<?php endif; ?>

<?php do_action( 'woocommerce_view_order', $order_id ); ?>
