<?php
$blogImage = get_field('blog_background_image', 'options');
$blogBgImage = wp_get_attachment_url($blogImage, 'large');
$mediaImage = get_field('media_wall_background', 'options');
$mediaBgImage = wp_get_attachment_url($mediaImage, 'large');

?>

<div class="news-sidebar">
    <div class="social">
        <div class="row">
            <?php if (!is_home()) { ?>
                <div class="col-6 share-post">
                    <p>Share this page</p>
                    <div class="addthis_inline_share_toolbox"></div>
                </div>
            <?php } ?>
            <?php if (!is_home() && get_next_post()) { ?>
                <div class="col-6 ">
                    <div class="next-posts sidebar">
                        <img class="bg-button"
                             src="<?php echo get_template_directory_uri(); ?>/dist/images/brush-device1.svg" alt="brush stroke background" />
                        <?php next_post_link('%link', 'Next article') ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <form role="search" method="get" class="search-form" action="<?php echo home_url('/worth-shouting-about/'); ?>">
        <input type="hidden" name="post_type" value="post">
        <input type="search" class="search-field"
               placeholder="<?php echo esc_attr_x('Search …', 'placeholder') ?>"
               value="<?php echo get_search_query() ?>" name="s"
               title="<?php echo esc_attr_x('Search for:', 'label') ?>"/>
        <input type="submit" class="go" value="Go">
    </form>
    <div class="dropdown">

        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton"
                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">All News
        </button>
        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
            <?php
            $categories = get_categories();
            foreach ($categories as $category) { ?>
                <a class="dropdown-item"
                   href="/worth-shouting-about?category=<?= $category->category_nicename; ?>"><?= $category->cat_name; ?></a>
            <?php } ?>
        </div>
    </div>
    <div class="tags">
        <h3>Find by tag:</h3>
        <?php $tags = get_tags();
        foreach ($tags as $tag) { ?>
            <a class="tag" href="/worth-shouting-about?tag=<?= $tag->slug; ?>"><?= $tag->name; ?></a>
        <?php } ?>
    </div>
    <?php if (!is_home()) { ?>
        <div class="recent-articles">
            <h2>Recent articles</h2>
            <?php
            $args = [
                'numberposts' => 5,
                'offset' => 0,
                'category' => 1,
                'orderby' => 'post_date',
                'order' => 'DESC',
                'include' => '',
                'exclude' => '',
                'meta_key' => '',
                'meta_value' => '',
                'post_type' => 'post',
                'post_status' => 'publish',
                'suppress_filters' => true,
            ];

            $recent_posts = wp_get_recent_posts($args, ARRAY_A);
            foreach ($recent_posts as $recent) { ?>

                <article class="news-loop-single ">
                    <div class="row">
                        <div class="col-lg-6">
                            <?php if (has_post_thumbnail($recent['ID'])) {
                                echo get_the_post_thumbnail($recent['ID'], 'news-archive');
                            } else { ?>
                                <img class="img-responsive"
                                     src="<?php echo get_template_directory_uri(); ?>/dist/images/placeholder-panel.jpg"/>
                            <?php } ?>
                        </div>
                        <div class="col-lg-6">
                            <header>
                                <h4 class="entry-title"><a
                                            href="/<?= $recent['post_name']; ?>"><?= $recent['post_title']; ?></a>
                                </h4>
                                <time class="updated" itemprop="datePublished"
                                      datetime="<?= get_post_time('c', true); ?>"><?= get_the_date(); ?></time>
                            </header>
                        </div>
                    </div>
                </article>

            <?php }
            wp_reset_query(); ?>
        </div>
    <?php } ?>
    <?php if (is_home()) { ?>
    <div class="recent-articles">
        <div class="row">
            <?php
            if (have_rows('tile', 'option')) {
                while (have_rows('tile', 'option')) {
                    the_row();
                    ?>
                    <div class="col-lg-12">
                        <?php Blue2\Scruffy\Site::getTile(get_sub_field('tile_pattern', 'option')); ?>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
    </div>
    <?php } ?>
</div>