<?php
$label = get_sub_field('call_to_action_label');
$url = get_sub_field('call_to_action_url');
$productImageId = get_sub_field('image');
$productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'general-tile') : false;
$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: 
		get_sub_field('title');
if($productImage !== false) {		
?>
	<figure class="tile tile--caption tile--img-hover">
		<?php if($label && $url) { ?>
			<a href="<?= $url; ?>">
		<?php } ?>


			<img class="img-fluid" src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />

			<?php if(get_sub_field('title') || get_sub_field('caption')) { ?>
				<figcaption class="tile--caption--text">
					<?php if(get_sub_field('title')) { ?>
						<h3 class="" ><?php the_sub_field('title'); ?></h3>
					<?php } ?>

					<?php if(get_sub_field('caption')) { ?>
						<p><?php the_sub_field('caption'); ?></p>
					<?php } ?>
				</figcaption>
			<?php } ?>

			<?php if($label) { ?>
				<span class="btn-graphic--alt accent"><?= $label; ?></span>
			<?php } ?>

			<?php if(get_sub_field('show_arrow')) { ?>
				<span class="accent <?php the_sub_field('arrow_position'); ?>"><?php the_sub_field('arrow_text'); ?></span>
			<?php } ?>

			<?php if($label && $url) { ?>
				</a>
			<?php } ?>
	</figure>
<?php }