<?php
/**
 * Single variation cart button
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;
?>
<div class="woocommerce-variation-add-to-cart variations_button">
	<?php
		/**
		 * @since 3.0.0.
		 */
		do_action( 'woocommerce_before_add_to_cart_quantity' );

		woocommerce_quantity_input( array(
			'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
			'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
			'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( $_POST['quantity'] ) : $product->get_min_purchase_quantity(),
		) );

		/**
		 * @since 3.0.0.
		 */
		do_action( 'woocommerce_after_add_to_cart_quantity' );
	?>
	
	<?php if(is_product()) { ?>
		<button type="submit" data-productid="<?= $product->get_id(); ?>"  class="single_add_to_cart_button button alt"><i class="fas fa-plus"></i> <span class="wording">add to my <br/> basket</span></button>
	<?php } else { ?>
		<button type="submit" data-productid="<?= $product->get_id(); ?>"  class="single_add_to_cart_button button alt"><i class="fas fa-plus"></i><br/>add</button>
	<?php } ?>
	<!-- <button type="submit" data-productid="<?= $product->get_id(); ?>"  class="single_add_to_cart_button button alt"><i class="fas fa-plus"></i><br/>add</button> -->
	<input type="hidden" name="add-to-cart" value="<?php echo absint( $product->get_id() ); ?>" />
	<input type="hidden" name="product_id" value="<?php echo absint( $product->get_id() ); ?>" />
	<input type="hidden" name="variation_id" class="variation_id" value="0" />
</div>
