<?php ?>
<section class="section section--media-cluster" >
    <div class="container">
        <div class="row">
			<div class="col-lg-8">
				<div class="row">
					<div class="col-12 single-video">
                        <h1 class="accent-title"><span>Latest from the<br /> ScottisH Butcher</span></h1>
						<div class="embed-responsive embed-responsive-16by9">
							<iframe class="embed-responsive-item" width="100%" src="https://www.youtube.com/embed/<?php the_sub_field('youtube_code'); ?>" 
								frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen>
								<?php 
								if(get_sub_field('top_caption')) {
										echo "<p>" . get_sub_field('top_caption') . "</p>";
								} 
								?>
							</iframe>
						</div>
					</div>

					<?php 
					if(is_tax() ) {
						$term = get_queried_object();
						if($term->slug === "supermarket") {
							$term = 'option';
						}
					} else {
						$term = get_the_ID();
					}

					if(have_rows('bottom_articles', $term)) {
						while(have_rows('bottom_articles', $term)) {
							the_row();
							$post = get_sub_field('article');
							setup_postdata($post);
							?>	

							<div class="col-6 col-md-4">
								<?php include(locate_template('templates/parts/tile-excerpt-mini.php')); ?>
							</div>

							<?php 
							wp_reset_postdata();
						} 
					} 
					?>
							
					<div class="col-6 d-md-none">
						<a href="<?= get_post_type_archive_link('post'); ?>" class="btn btn-graphic">View all articles</a>
					</div>
				</div>
			</div>

			<?php  
			if(have_rows('full_height_panel', $term)) {
				while(have_rows('full_height_panel', $term)) {
					the_row();
					$pattern = get_sub_field('pattern');
					if($pattern === "free-form") {
						$imageId = get_sub_field('image');
					} elseif($pattern === "social-media") {
						global $post;
						$post = get_sub_field('social_media_post');
						setup_postdata($post); 
						$imageId = get_post_thumbnail_id();
					}
					$url = $pattern === "free-form" ? get_sub_field('call_to_action_url') : get_field('call_to_action_url', $post);
					$label = $pattern === "free-form" ? get_sub_field('call_to_action_label') : "View Post";
					$text = $pattern === "free-form" ? get_sub_field('text') : get_the_content();

					$image = $imageId ? wp_get_attachment_image_src($imageId, 'portrait-advert') : 
							[get_template_directory_uri() . "/dist/images/default-portrait-advert-800-1407.jpg"];
					$imageAlt = get_post_meta($imageId, '_wp_attachment_image_alt', true) ?: '';
					?>
					<div class="col-lg-4">
						<article class="img-advert">
							<a href="<?= $url; ?>">
								<img class="img-fluid" src="<?= $image[0]; ?>" alt="<?= $imageAlt; ?>" />

								<?php if($text || $label) { ?>
									<div class="content">
										<?php if($text) { ?>
												<span class="caption"><?= $text; ?></span>
										<?php } ?>

										<?php if($label) { ?>
												<span class="label"><?= $label; ?></span>
										<?php } ?>
									</div>
								<?php } ?>
							</a>
						</article>
					</div>
					<?php
				}
			} wp_reset_postdata(); 
			?>
            <div class="next-ctas">
                <a class="accent-title" href="<?= get_permalink(get_option('page_for_posts')); ?>">View more Articles<br/><span>Worth <span>sH</span>outing about</span></a>
                <p class="share">Share this page
                    <div class="addthis_inline_share_toolbox"></div>
                </p>
            </div>
        </div>
    </div>
</section>