<?php
/**
 * Order details table shown in emails.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates/Emails
 * @version     3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$text_align = is_rtl() ? 'right' : 'left';

// do_action( 'woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email ); ?>

<?php
global $wpdb;

$shippingDetails = Blue2\Scruffy\Controllers\WoocommerceController::getShippingDetails($order);
$isDelivery = Blue2\Scruffy\Controllers\WoocommerceController::getOrderType($order) == 'ship';


if (!$isDelivery) {
    $order_itemmeta = $wpdb->prefix . 'woocommerce_order_itemmeta';
    $order_items = $wpdb->prefix . 'woocommerce_order_items';
    $timeResults = $wpdb->get_results("
SELECT p.meta_value
			FROM {$order_itemmeta} AS p
			JOIN {$order_items} AS psi ON psi.order_item_id = p.order_item_id
			WHERE p.meta_key = '_pickup_appointment_start'
			AND psi.order_id = {$order->get_id()}
		", ARRAY_N);

    $time = date_i18n(wc_time_format(), $timeResults[0][0]);
    $timeEnd = date_i18n(wc_time_format(), $timeResults[0][0] + 7200);

    $date = date_i18n(wc_date_format(), $timeResults[0][0]);
?>

<p><strong>Collection date: <span class="orange-letters"><?= $date; ?></span></strong></p>
<p><strong>Collection time between: <span class="orange-letters"><?= $time; ?> - <?= $timeEnd; ?></span></strong></p>
<p><strong>Collection place: <span class="orange-letters"><a href="https://christmas.thescottishbutcher.com/festive-opening-times/" target="_blank" ><?= $shippingDetails['Pickup Location']; ?></a></span></strong></p>

<?php } else {
    $deliveryDate = get_post_meta($order->get_id(), 'deliveryDate'); ?>
    <p><strong>Delivery date: <span class="orange-letters"><?= $deliveryDate[0]; ?></span></strong></p>
<?php } ?>

<?php Blue2\Scruffy\Controllers\WoocommerceController::b2ViewOrder($order); ?>