<?php 
$sliders = get_field('sliders');
if($sliders) {
    shuffle($sliders);
    $randomSlider = $sliders[0];

    $image = isset($randomSlider['image']) ? wp_get_attachment_image_src($randomSlider['image'], 'full') : '';
    $imageAlt = get_post_meta($randomSlider['image'], '_wp_attachment_image_alt', true) ?: '';
    $ctaLabel = isset($randomSlider['call_to_action_label']) ? $randomSlider['call_to_action_label'] : '';
    $ctaUrl = isset($randomSlider['call_to_action_url']) ? $randomSlider['call_to_action_url'] : '';
}
?>
<section class="section section--large-banner" >
    <div class="banner-left" style="background-image:url('<?= wp_get_attachment_image_src(get_field('banner_left_image'), 'fullwidth')[0]; ?>');">
        <a href="<?php the_field('banner_left_url'); ?>" class="accent"><?php the_field('banner_left_text'); ?></a>
    </div>
    <div class="banner-right banner-right--top" style="background-image:url('<?= wp_get_attachment_image_src(get_field('banner_right_top_image'), 'fullwidth')[0]; ?>');">
        <a href="<?php the_field('banner_right_top_url'); ?>" class="accent"><?php the_field('banner_right_top_text'); ?></a>
    </div>
    <div class="banner-right banner-right--bottom" style="background-image:url('<?= wp_get_attachment_image_src(get_field('banner_right_bottom_image'), 'fullwidth')[0]; ?>');">
        <a href="<?php the_field('banner_right_bottom_id'); ?>" class="accent"><?php the_field('banner_right_bottom_text'); ?></a>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-xl-8 offset-xl-2">
				<div class="banner-msg">
                    <h1 class="accent-title accent"><?php the_field('main_big_title'); ?></h1>

                    <?php 
                    if(have_rows('main_middle_panel')) { 
                        get_template_part('templates/parts/main_middle_panel');
                    } 
                    ?>
                </div>

            </div>
        </div>
    </div>

</section>