<?php $text_align = is_rtl() ? 'right' : 'left'; ?>
<div style="margin-bottom: 40px;">
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; font-size: 13px;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:<?= $text_align; ?>; width: 300px; font-size: 15px;"><?php _e( 'Product', 'woocommerce' ); ?></th>
				<!-- <th class="td" scope="col" style="text-align:<?= $text_align; ?>;"><?php _e( 'Weight', 'woocommerce' ); ?></th> -->
				<!-- <th class="td" scope="col" style="text-align:<?= $text_align; ?>;"><?php _e( 'Unit Label', 'woocommerce' ); ?></th> -->
				<!-- <th class="td" scope="col" style="text-align:<?= $text_align; ?>;"><?php _e( 'Units', 'woocommerce' ); ?></th> -->
				<th class="td" scope="col" style="text-align:<?= $text_align; ?>;"><?php _e( 'Size', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?= $text_align; ?>;"><?php _e( 'Qty', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?= $text_align; ?>;"><?php _e( 'Approx', 'woocommerce' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php 
			$styles = "vertical-align:middle; border: 1px solid #eee; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;";
			foreach($order->get_items() as $itemKey => $item) { 
				$product = $item->get_product();
				$productMeta = get_post_meta($product->get_id());
				?>
				<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'order_item', $item, $order ) ); ?>">
					<td class="td" style="text-align:<?php echo $text_align; ?>; <?= $styles; ?> font-size: 15px;">
					 	<?php echo apply_filters( 'woocommerce_order_item_name', $item->get_name(), $item, false ); ?>
					</td>
					<!-- <td class="td" style="text-align:<?php echo $text_align; ?>; <?= $styles; ?>">
						<?php
						if (wc_get_order_item_meta($itemKey, 'Required Weight (g)')) {
							$weight = wc_get_order_item_meta($itemKey, 'Required Weight (g)');
						} else if (wc_get_order_item_meta($itemKey, 'Weight (g)')) {
							$weight = wc_get_order_item_meta($itemKey, 'Weight (g)');
						} else {
							$weight = '';
						} 
						$weight = $weight !== '' ? $weight . 'g' : '';
						
						echo $weight;
						?>
					</td>
					<td class="td" style="text-align:<?php echo $text_align; ?>; <?= $styles; ?>">
						<?php 
						$unitLabel = array_key_exists('unit_label', $productMeta) ? $productMeta['unit_label'][0] : '';
						echo $unitLabel;
						?>
					</td>
					<td class="td" style="text-align:<?php echo $text_align; ?>; <?= $styles; ?>">
                        <?php 
                            $result = '';
							if (array_key_exists('weight_of_one_unit', $productMeta)) {
								$unit = $productMeta['weight_of_one_unit'][0];
							} elseif (array_key_exists('weight_to_feed_one_person', $productMeta)) {
								$unit = $productMeta['weight_to_feed_one_person'][0];
							} else {
                                $unit = "";
                            }

							if (wc_get_order_item_meta($itemKey, 'Required Weight (g)')) {
								$weightL =  wc_get_order_item_meta($itemKey, 'Required Weight (g)');
							} else if (wc_get_order_item_meta($itemKey, 'Weight (g)')) {
								$weightL =  wc_get_order_item_meta($itemKey, 'Weight (g)');
							} else {
								$weightL =  '';
							}

							if ($unit > 0) {
								$result = ($weightL && $unit > 0 ? ($weightL / $unit) : '');
							} else if (array_key_exists('unit_label', $productMeta)) {
								$result = $productMeta['unit_label'][0];
							}

							$result = $result !== "" ? floor($result) : "";

							echo $result;
						?>
					</td> -->
					<td class="td" style="text-align:<?php echo $text_align; ?>; <?= $styles; ?>">
						<?php
						$packSize = '';
						if ($product->is_type('variation')) {
							$packSize = '';
							$variation_attributes = $product->get_variation_attributes();
							foreach ($variation_attributes as $attribute_taxonomy => $term_slug) {
								$packSize .= '<span class="pack-option">'.$term_slug.'</span> ';
							}
						}

						echo $packSize;
						?>
					</td>
					<td class="td" style="text-align:<?= $text_align; ?>; <?= $styles; ?>"><?= apply_filters( 'woocommerce_email_order_item_quantity', $item->get_quantity(), $item ); ?></td>
					<td class="td" style="text-align:<?php echo $text_align; ?>; <?= $styles; ?>"><?= $order->get_formatted_line_subtotal( $item ); ?></td>
				</tr>
			<?php } ?>
		</tbody>
		<tfoot>
			<?php
				if ( $totals = $order->get_order_item_totals() ) {
					$i = 0;
					foreach ( $totals as $total ) {
						$i++;
						if($total['label'] == 'Shipping:') {
 							?>
							<tr>
								<th class="td" scope="row" colspan="2" style="text-align:<?= $text_align; ?>; <?= ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?= $total['label']; ?></th>
								<td class="td" colspan="2" style="text-align:<?= $text_align; ?>; <?= ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?= $total['value']; ?></td>
							</tr>
 						<?php } elseif($total['label'] == 'Total:') { ?>
							<tr>
								<th class="td" scope="row" colspan="2" style="text-align:<?= $text_align; ?>; <?= ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>">Approx: </th>
								<td class="td" colspan="2" style="text-align:<?= $text_align; ?>; <?= ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?= $total['value']; ?></td>
							</tr>
						<?php } elseif($total['label'] == 'Discount:') { ?>
							<tr>
								<th class="td" scope="row" colspan="2" style="text-align:<?= $text_align; ?>; <?= ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>">Discount: </th>
								<td class="td" colspan="2" style="text-align:<?= $text_align; ?>; <?= ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?= $total['value']; ?></td>
							</tr>
						<?php
						}
					
					}
				}
				if ( $order->get_customer_note() ) {
					?><tr>
						<th class="td" scope="row" colspan="2" style="text-align:<?= $text_align; ?>;"><?php _e( 'Note:', 'woocommerce' ); ?></th>
						<td class="td" colspan="2" style="text-align:<?= $text_align; ?>;"><?= wptexturize( $order->get_customer_note() ); ?></td>
					</tr><?php
				}
			?>
		</tfoot>
	</table>
</div>