<?php

namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\StoreController;
use Blue2\Scruffy\Controllers\WoocommerceController;
use Blue2\Scruffy\Post\Store;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_action('after_setup_theme', [$this, 'customImageSizes']);
        add_action('admin_menu', [$this, 'customAdminPages']);

        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_filter('found_posts', [$this,'ajustOffsetPagination'], 1, 2 );

        add_filter('mce_buttons', [$this, 'updateMCEButtons']);
        add_filter('tiny_mce_before_init', [$this,'customMCEBeforeInit'] );


        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    function updateMCEButtons($buttons) 
    {
        array_unshift( $buttons, 'styleselect' );
        return $buttons;
    }

    // Adding format buttons to wysiwyg
    function customMCEBeforeInit($init_array) 
    {  
        $style_formats = [
            [ 
                'title' => 'Accent h2',  
                'block' => 'h2',  
                'classes' => 'accent', 
            ],  
            [ 
                'title' => 'Accent h3',  
                'block' => 'h3',  
                'classes' => 'accent', 
            ],  
            [ 
                'title' => 'Accent h4',  
                'block' => 'h4',  
                'classes' => 'accent', 
            ],  
            [ 
                'title' => 'Branded bullet points',  
                'selector' => 'ul',  
                'classes' => 'brand', 
            ], 
          
        ];  

        $init_array['style_formats'] = json_encode( $style_formats );  
        
        return $init_array;  
    }

    /** May need refactoring if any other post types used are being paginated */
    function ajustOffsetPagination($found_posts, $query) 
    {
        $offset = 1;
        // Make a check around this to make sure it is only applied for required post types
        return $found_posts - $offset;

        return $found_posts;
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters()
    {
        add_filter('acf/fields/google_map/api', [$this, 'acfApiKey']);
    }

    private function registerActions()
    {

    }

    private function setupControllers()
    {
        new WoocommerceController();
    }

    public static function customPagination()
    {
        global $wp_query;

        echo paginate_links([
            'base' => str_replace(99999999, '%#%', esc_url(get_pagenum_link(99999999))),
            'format' => '?paged=%#%',
            'current' => max(1, get_query_var('paged')),
            'total' => $wp_query->max_num_pages,
        ]);
    }

    public static function getTile($pattern = null)
    {
        if($pattern) {
            switch ($pattern) {
                case 'free-form':
                    get_template_part('templates/parts/tile-caption-marketing');
                    break;
                case 'image':
                case 'link-to-video':
                case 'accreditation':
                    include(locate_template('templates/parts/tile-basic.php'));
                    break;
                case 'blog-post':
                case 'person':
                case 'product':
                    include(locate_template('templates/parts/tile-caption.php'));
                    break;
                case 'recipe':
                    get_template_part('templates/parts/tile-caption-recipe');
                    break;
                case 'free-space':
                    get_template_part('templates/parts/text-panel');
                    break;
                case 'accordion':
                    get_template_part('templates/parts/accordion-panel');
                    break;
                case 'single-social-media':
                    get_template_part('templates/parts/single-social-media');
                    break;
                case 'social-media':
                    $count = 3;
                    echo "<div class='social-stream d-none d-xl-block'>";
                    include(locate_template('templates/parts/social-media-menu.php'));
                    echo "</div>";
                    break;
            }
        } else {
            get_template_part('templates/parts/tile-caption-marketing');
        }
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';

    }

    public function customImageSizes()
    {
        add_image_size('general-tile', 800, 605, true);
        add_image_size('thin-tile', 920, 395, true);
        add_image_size('news-archive', 470, 360, true);
        add_image_size('news-single', 960);
        add_image_size('award-square', 200, 200, true);
        add_image_size('product-square', 700, 700, true);
        add_image_size('portrait-advert', 800, 1407, true);
        add_image_size('fullwidth-banner', 1980, 1200, true);
        add_image_size('ad-vacancy', 950, 85, true);
        add_image_size('fluid-length', 800); // height will be recalculated to keep the dimensions
        add_image_size('fullwidth', 1920); // height will be recalculated to keep the dimensions
    }

    public function customAdminPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'page_title' => 'Product Archive',
                'parent' => 'edit.php?post_type=product',
                'capability' => 'edit_posts',
            ]);

            acf_add_options_page([
                'title' => 'Email Templates',
                'capability' => 'edit_posts',
                'icon_url' => 'dashicons-email-alt'
            ]);
        }
    }

    public function acfApiKey($api)
    {
        $api['key'] = 'AIzaSyAGsKZ5PP8iURMpB4kRQKcpLQps-szGeqw';
        // TODO: SIMON HOWIE KEY, NOT ACTIVE YET
//        $api['key'] = 'AIzaSyBL-BESfZ6rPCgsN2ypgor4vfU-_TuUZoQ';
        return $api;

    }

}
