<?php 

$title = get_sub_field("title") ?? "";
$link = get_sub_field("link") ?? "";
$linkText = get_sub_field("link_text") ?? "";

if(get_sub_field('categories')) { 
    $categories = get_sub_field('categories');
    ?>
    <section class="section section--product-slider-supermarket range-slider" >
        <div class="container">
            <div class="row">
                <h2 class="accent"><?= $title !== "" ? $title : "Browse Our Range"; ?></h2>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="swiper-container swiper-products-supermarket">
                    <div class="swiper-wrapper">
                        <?php 
                            foreach($categories as $category) { 
                                $productImageId = get_woocommerce_term_meta( $category->term_id, 'thumbnail_id', true );
                                $productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'award-square') : [get_template_directory_uri() . "/dist/images/product-package-240-175.png"];
                                $productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: $category->name;
                                ?>
                                <div class="swiper-slide">
                                    <a href="<?= get_term_link($category->term_id); ?>">
                                        <img src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />
                                        <p><?= $category->name; ?></p>
                                    </a>
                                </div>
                        <?php }?>
                    </div>
                    <!-- Add Arrows -->
                    <div class="swiper-button-next swiper-button-next--range"></div>
                    <div class="swiper-button-prev swiper-button-prev--range"></div>
                </div>
            </div>
        </div>
        <?php if($linkText !== "") { ?>
            <a class="range-slider-cta" href="<?= $link ?>"><span class="cac-btn-graphic--alt btn-graphic--alt accent"><?= $linkText ?></span></a>
        <?php } ?>
    </section>
<?php } wp_reset_postdata();