<?php
if(is_singular('product') || $pattern === 'product') {
	global $post;
	$post = get_sub_field('product');
	setup_postdata( $post ); 
	$label = 'View More';
	$url = get_the_permalink();
	$title = get_the_title();
	$caption = wp_trim_words(get_the_content(), 18, '...');
	$productImageId = get_post_thumbnail_id();
} else {
	$label = get_sub_field('call_to_action_label');
	$url = get_sub_field('call_to_action_url');
	$title = get_sub_field('title');
	$caption = get_sub_field('caption');
	$productImageId = get_sub_field('image');
}

$productImage = $productImageId ? wp_get_attachment_image_src($productImageId, 'general-tile') : false;
$productImageAlt = get_post_meta(get_post_thumbnail_id($productImageId), '_wp_attachment_image_alt', true) ?: $title;
if($productImage !== false) {
?>
	<figure class="tile tile--caption tile--img-hover">
		<?php if($label && $url) { ?>
			<a href="<?= $url; ?>">
				<span class="cta btn-graphic"><?= $label; ?></span>
		<?php } ?>

			<img class="img-fluid" src="<?= $productImage[0]; ?>" alt="<?= $productImageAlt; ?>" />

			<figcaption class="tile--caption--text">
				<?php if($title) { ?>
					<h3><?= $title; ?></h3>
				<?php } ?>

				<?php if($caption) { ?>
					<p><?= $caption; ?></p>
				<?php } ?>
			</figcaption>

			<?php if($label && $url) { ?>
				</a>
			<?php } ?>
	</figure>
<?php } wp_reset_postdata();