<?php

namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\StoreController;
use Blue2\Scruffy\Controllers\WoocommerceController;
use Blue2\Scruffy\Post\Store;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_action('after_setup_theme', [$this, 'customImageSizes']);
        add_action('admin_menu', [$this, 'customAdminPages']);

        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_filter('found_posts', [$this,'ajustOffsetPagination'], 1, 2 );

        add_filter('mce_buttons', [$this, 'updateMCEButtons']);
        add_filter('tiny_mce_before_init', [$this,'customMCEBeforeInit'] );

        add_action('woocommerce_checkout_process', [$this,'custom_validate_billing_phone']);
        add_action('woocommerce_after_order_notes', [$this,'add_custom_checkout_hidden_field']);

        add_action('woocommerce_order_actions',  [&$this, 'amended_email_action']); 
        add_action('woocommerce_order_action_amended_email', [&$this, 'fired_my_amended_email_action']);

        add_filter('woocommerce_package_rates', [$this, 'calculateFreePostage'], 999, 2);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    function updateMCEButtons($buttons) 
    {
        array_unshift( $buttons, 'styleselect' );
        return $buttons;
    }

    // Adding format buttons to wysiwyg
    function customMCEBeforeInit($init_array) 
    {  
        $style_formats = [
            [ 
                'title' => 'Accent h2',  
                'block' => 'h2',  
                'classes' => 'accent', 
            ],  
            [ 
                'title' => 'Accent h3',  
                'block' => 'h3',  
                'classes' => 'accent', 
            ],  
            [ 
                'title' => 'Accent h4',  
                'block' => 'h4',  
                'classes' => 'accent', 
            ],  
            [ 
                'title' => 'Branded bullet points',  
                'selector' => 'ul',  
                'classes' => 'brand', 
            ], 
          
        ];  

        $init_array['style_formats'] = json_encode( $style_formats );  
        
        return $init_array;  
    }

    /** May need refactoring if any other post types used are being paginated */
    function ajustOffsetPagination($found_posts, $query) 
    {
        $offset = 1;
        // Make a check around this to make sure it is only applied for required post types
        return $found_posts - $offset;

        return $found_posts;
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters()
    {
        add_filter('acf/fields/google_map/api', [$this, 'acfApiKey']);
    }

    private function registerActions()
    {

    }

    private function setupControllers()
    {
        new WoocommerceController();
    }

    public static function customPagination()
    {
        global $wp_query;

        echo paginate_links([
            'base' => str_replace(99999999, '%#%', esc_url(get_pagenum_link(99999999))),
            'format' => '?paged=%#%',
            'current' => max(1, get_query_var('paged')),
            'total' => $wp_query->max_num_pages,
        ]);
    }

    public static function getTile($pattern = null)
    {
        if($pattern) {
            switch ($pattern) {
                case 'free-form':
                    get_template_part('templates/parts/tile-caption-marketing');
                    break;
                case 'image':
                case 'link-to-video':
                case 'accreditation':
                    include(locate_template('templates/parts/tile-basic.php'));
                    break;
                case 'blog-post':
                case 'person':
                case 'product':
                    include(locate_template('templates/parts/tile-caption.php'));
                    break;
                case 'recipe':
                    get_template_part('templates/parts/tile-caption-recipe');
                    break;
                case 'free-space':
                    get_template_part('templates/parts/text-panel');
                    break;
                case 'accordion':
                    get_template_part('templates/parts/accordion-panel');
                    break;
                case 'single-social-media':
                    get_template_part('templates/parts/single-social-media');
                    break;
                case 'social-media':
                    $count = 3;
                    echo "<div class='social-stream d-none d-xl-block'>";
                    include(locate_template('templates/parts/social-media-menu.php'));
                    echo "</div>";
                    break;
            }
        } else {
            get_template_part('templates/parts/tile-caption-marketing');
        }
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';

    }

    public function customImageSizes()
    {
        add_image_size('general-tile', 800, 605, true);
        add_image_size('thin-tile', 920, 395, true);
        add_image_size('news-archive', 470, 360, true);
        add_image_size('news-single', 960);
        add_image_size('award-square', 200, 200, true);
        add_image_size('product-square', 700, 700, true);
        add_image_size('portrait-advert', 800, 1407, true);
        add_image_size('fullwidth-banner', 1980, 1200, true);
        add_image_size('ad-vacancy', 950, 85, true);
        add_image_size('fluid-length', 800); // height will be recalculated to keep the dimensions
        add_image_size('fullwidth', 1920); // height will be recalculated to keep the dimensions
    }

    public function customAdminPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'page_title' => 'Product Archive',
                'parent' => 'edit.php?post_type=product',
                'capability' => 'edit_posts',
            ]);

            acf_add_options_page([
                'title' => 'Email Templates',
                'capability' => 'edit_posts',
                'icon_url' => 'dashicons-email-alt'
            ]);
        }
    }

    public function acfApiKey($api)
    {
        $api['key'] = 'AIzaSyAGsKZ5PP8iURMpB4kRQKcpLQps-szGeqw';
        // TODO: SIMON HOWIE KEY, NOT ACTIVE YET
//        $api['key'] = 'AIzaSyBL-BESfZ6rPCgsN2ypgor4vfU-_TuUZoQ';
        return $api;

    }
    
    function custom_validate_billing_phone() {

        $pattern = "/^0([1-6][0-9]{8,10}|7[0-9]{9})$/";
        $is_correct = preg_match($pattern, $_POST['billing_phone']);
        if ( $_POST['billing_phone'] && !$is_correct) {
            wc_add_notice( __( 'The Phone field should be a valid uk telephone number.' ), 'error' );
        }
    }

    function add_custom_checkout_hidden_field( $checkout ) {
    
        // Output the hidden field
        echo '<div id="user_link_hidden_checkout_field">
                <input type="hidden" class="input-hidden" name="MC_CustomerOrderNote" id="MC_CustomerOrderNote" value="-">
        </div>';
    }
    
    function amended_email_action( $actions ) {

        if ( is_array( $actions ) ) {
            $actions['amended_email'] = __( 'Send order amended email' );
        }
    
        return $actions;
    
    }

    function fired_my_amended_email_action( $order ) {

        // Change the post saved message.
        add_filter( 'redirect_post_location', array( __CLASS__, 'set_email_sent_message' ) );
    }

    public function calculateFreePostage($rates, $packages = array())
    {
        $cartTotal = WC()->cart->get_subtotal();
        $freeDeliveryThreshold = get_field('free_delivery_threshold', 'option') ?? "";

        if ($freeDeliveryThreshold !== "") {
            if ($cartTotal >= $freeDeliveryThreshold) {
                foreach ($rates as &$rate) {
                    if ($rate->get_method_id() == 'flat_rate') {
                        $rate->set_cost(0);
                        $rate->set_label('Free Delivery');
                    }
                }
            }

            //override to deal with new customer issue
            if (isset($_POST['deliveryType']) && $_POST['deliveryType'] == 'ship' || count($rates) > 1) {
                if ($cartTotal >= $freeDeliveryThreshold) {
                    foreach ($rates as &$rate) {
                        $rate->set_cost(0);
                        $rate->set_label('Free Delivery');
                    }
                } else {
                    foreach ($rates as &$rate) {
                        $methods = WC()->shipping->get_shipping_methods();
                        $rate->set_cost($methods['13']->cost);
                        $rate->set_label($methods['13']->title);
                    }
                }
            }
        }
        return $rates;
    }

    function custom_add_to_cart($cart_item_key,  $product_id,  $quantity,  $variation_id,  $variation,  $cart_item_data)
    {
            ?>
            <div class="modal fade" id="additionalProductModal" tabindex="-1" role="dialog"
                aria-labelledby="additionalProductTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-12 col-lg-5 pr-lg-0">
                                    <?php $image = get_the_post_thumbnail_url($product_id, 'fullwidth'); ?>
                                    <div class="main-image">
                                        <img src="<?= $image; ?>" class="img-fluid"/>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-7">
                                    <h5 class="modal-title accent" id="additionalProductTitle">Excellent</h5>
                                    <p class="basket-message" style="color: black;"><i class="far fa-check-circle"></i><span><?= get_the_title($product_id); ?></span> has been added to your cart.</p>
                                    
                                    <div class="modal-buttons">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Continue Shopping</button>
                                        <a href="<?= wc_get_checkout_url() ?>" class="btn btn-primary">Checkout</a>
                                    </div>
                                </div>
                            </div>
        
                            <?php if(get_field('relevant_products',$product_id)) { ?>
                                <div class="row">
                                    <div class="col-12">
                                        <h6 class="accent">Goes great with</h6>
                                    </div>
        
                                    <?php
                                    $products = get_field('relevant_products',$product_id);
                                    $count = 0;
                                    foreach($products as $postId) {
                                        $post_object = get_post($postId);    
                                        $image = get_the_post_thumbnail_url($postId, 'fullwidth');
                                        $count++;
                                        if($count < 5) {
                                        ?>
                                            <div class="col-12 col-lg-6">
                                                <div class="great-with">
                                                    <img src="<?= $image; ?>" class="img-fluid"/>  
                                                    <a href="<?php echo get_permalink($post_object->ID); ?>">
                                                        <?php echo get_the_title($post_object->ID); ?>
                                                        <span class="btn btn-graphic--alt accent">Add to Order</span>
                                                    </a>
                                                </div>
                                            </div>
                                        <?php
                                        }
                                    }
                                    ?>
                                </div>
                            <?php } ?>
                        
                        
                            <div class="container-fluid">
                                <div class="row">
                                    <?php
                                    global $post;
                                    while (have_rows('modal_information_products',$product_id)) {
                                        the_row();
                                        $post = get_sub_field('product');
                                        get_template_part('templates/parts/related-cats');
                                        wp_reset_postdata();
                                    } ?>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
            <?php
    }
}
