<?php
$list_title = get_sub_field('list_title');
$button = get_sub_field('button_below_list');
$right_content = get_sub_field('right_content');
$cut_out_image = get_sub_field('cut_out_image');
?>

<section class="left_list_and_right_cut_out_section">
    <div class="first-row seondary_bg_color">
        <div class="container-fluid site-padding cut-out-section-negative-margin">
            <div class="row">
                <div class="col-lg-4">
                    <h1><?= $list_title; ?></h1>
                </div>
                <div class="col-lg-6">
                    <?= $right_content; ?>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4">
                    <div class="sidebar">
                        <ul class="latest-jobs-list">
                            <?php
                                $args = array( 
                                    'post_type'   => 'job_listing',
                                    'posts_per_page'=> 5,
                                    'orderby' => 'date',
                                    'order'   => 'date',
                                );

                                $query = new WP_Query( $args );
                                while( $query->have_posts() ) : $query->the_post()
                            ?>
                                <a href="<?=the_permalink();?>">
                                    <li class="latest-jobs-list-item">
                                        <i class="fas fa-arrow-right"></i> <?=the_title();?>
                                    </li>
                                </a>

                            <?php
                                endwhile;
                            ?>
                        </ul>
                    </div>
                    <?php if ($button != "") : ?><a href="<?= $button ?>" class="btn btn-primary mobile-center-btn">Find Out More <i class="fas fa-arrow-right"></i></a><?php endif; ?>
                </div>
                <div class="d-none d-lg-block col-lg-8">
                    <div class="right-cut-out-img" style="background-image: url('<?= $cut_out_image ?>');"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="white-bg-color">
        <div class="container-fluid site-padding">
            <div class="row">
                <div class="col-sm-12 d-lg-none">
                    <img class="right-cut-out-image" src="<?= $cut_out_image ?>" alt="">
                </div>
                <div class="col-sm-12">
                    <ul class="social-media-icons text-sm-center">
                        <?php while( have_rows('social_media_channels', 'options') ) : the_row(); ?>
                            <li><a href="<?=get_sub_field('full_url');?>" target="_blank"><i class="<?= get_sub_field('fa5_icon_class'); ?>"></i></a></li>
                        <?php endwhile; ?>
                        <li class="socials-tagline">Keep up to date!</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>