<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_action('wp_enqueue_scripts', [$this, 'neilson_enqueue_scripts']);
        add_action( 'wp_ajax_filterJobs',[$this,'filter_jobs']);
        add_action( 'wp_ajax_nopriv_filterJobs',[$this,'filter_jobs']);


        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function filter_jobs() 
    {
        $data = $_POST;
        $filter   = ! empty( $data[ 'select' ] ) ? $data[ 'select' ] : '';
        $location = ! empty( $data[ 'search_location' ] ) ? $data[ 'search_location' ] : '';
        $keywords = ! empty( $data[ 'search_keywords' ] ) ? $data[ 'search_keywords' ] : '';

        switch ($filter) {
            case 'position':
                $args = array( 
                    'orderby' => 'position',
                    'order'   => 'DESC',
                    'search_location'   => $location,
                    'search_keywords'   => $keywords,
                );

                break;
            case 'date':
                $args = array( 
                    'orderby' => 'date',
                    'order'   => 'DESC',
                    'search_location'   => $location,
                    'search_keywords'   => $keywords,
                );
                break;
            default:
                $args = array( 
                    'orderby' => 'date',
                    'order'   => 'DESC',
                    'search_location'   => $location,
                    'search_keywords'   => $keywords,
                );
        }
        
        ob_start();
        $jobs = get_job_listings($args);

        if ( $jobs->have_posts() ) {
			while ( $jobs->have_posts() ) {
				$jobs->the_post();
				get_job_manager_template_part( 'content', 'job_listing' );
			}
		} else {
			get_job_manager_template_part( 'content', 'no-jobs-found' );
		}

        $result = ob_get_clean();
        wp_send_json_success($result);
    }

    public function neilson_enqueue_scripts()
    {
        wp_register_script( 'slick-js', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array(), false, true);
        wp_localize_script('slick-js', 'neilsonAjax', array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax-nonce')
        ));
        wp_enqueue_script( 'slick-js' );
        wp_enqueue_style('slick-css','https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css');
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' <br/><br/><a href="' . get_permalink() . '"><strong>Read more</strong></a>';
    }

    function shorter_excerpt_length() {
        return 30;
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
        add_filter( 'excerpt_length', [$this, 'shorter_excerpt_length']);
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        //Empty
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
    }
}