const common = () => {
    console.log('This gets run on every page and is exported as the default funciton. This will require a function call to run');
};

console.log('Any plain javascript will instantly run from an imported file');

export default common;

$(document).ready(function(){
    $('.testimonials-sect-container').slick({
        arrows: false,
        dots: true,
        dotsClass: 'pagination-dots testimonial-dots',
        infinite: false,
    });
    $('.testimonial-container').slick({
        arrows: false,
        dots: true,
        dotsClass: 'pagination-dots',
        infinite: false,
    });
    $('.news-slider').slick({
        arrows: false,
        dots: true,
        dotsClass: 'pagination-dots center-dots',
        infinite: false,
    });
});

function disableScrolling(){
    var x=window.scrollX;
    var y=window.scrollY;
    window.onscroll=function(){window.scrollTo(x, y);};
}

function enableScrolling(){
    window.onscroll=function(){};
}

let canScroll = false;

$('#hamburger-menu').on("click", function(event) {
    canScroll = !canScroll;
    document.getElementById("dropdown-nav-overlay").classList.toggle("hide");
    document.getElementById("dropdown-nav").classList.toggle("dropdown-nav-open");

    canScroll ? disableScrolling() : enableScrolling();
});

$('#dropdown-nav-overlay').on("click", function(event) {
    if (canScroll) {
        document.getElementById("dropdown-nav-overlay").classList.add("hide");
        document.getElementById("dropdown-nav").classList.remove("dropdown-nav-open");
        canScroll = false;
        enableScrolling();
    }
});

$('#sort').on( "change", function(event) {
    let select = $(this).val();

    let keyword = $('#search_keywords').val();
    let location = $('#search_location').val();

    const formData = new FormData();
    formData.append('select', select);
    formData.append('search_keywords', keyword);
    formData.append('search_location', location);
    formData.append('action', 'filterJobs');
    formData.append('nonce', neilsonAjax.nonce);

    $.ajax({
        url: neilsonAjax.url,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function() {
            $('ul.job_listings').addClass('loading');
            // $('ul.job_listings').children('li').css("visibility", "hidden");
            $('ul.job_listings').empty();
        },
        success : function( response ) {
            $('ul.job_listings').append(response.data);
            // $('ul.job_listings').children('li').css("visibility", "visible");
            $('ul.job_listings').removeClass('loading');
        }
    });
    event.preventDefault();   
});

$('div.content-align').each(function() {
    let leftContainer = $(this).find('.left-container');
    let rightContainer = $(this).find('.right-container');

    let rightTitle = $(rightContainer).find('.title-container').height();
    let leftTitle = $(leftContainer).find('.title-container').height();
    let rightContent = $(rightContainer).find('.aligned-content-container').height();
    let leftContent = $(leftContainer).find('.aligned-content-container').height();

    if(rightTitle > leftTitle) {
        $(rightContainer).find('.title-container').height(rightTitle);
        $(leftContainer).find('.title-container').height(rightTitle);
    } else if(leftTitle > rightTitle) {
        $(rightContainer).find('.title-container').height(leftTitle);
        $(leftContainer).find('.title-container').height(leftTitle);
    }  else if(leftTitle == rightTitle) {
        $(rightContainer).find('.title-container').height(rightTitle);
        $(leftContainer).find('.title-container').height(leftTitle);
    }

    if(rightContent > leftContent) {
        $(rightContainer).find('.aligned-content-container').height(rightContent);
        $(leftContainer).find('.aligned-content-container').height(rightContent);
    } else if(leftContent > rightContent) {
        $(rightContainer).find('.aligned-content-container').height(leftContent);
        $(leftContainer).find('.aligned-content-container').height(leftContent);
    }  else if(leftContent == rightContent) {
        $(rightContainer).find('.aligned-content-container').height(rightContent);
        $(leftContainer).find('.aligned-content-container').height(leftContent);
    }
});