<?php
/**
 * Filters in `[jobs]` shortcode.
 *
 * This template can be overridden by copying it to yourtheme/job_manager/job-filters.php.
 *
 * @see         https://wpjobmanager.com/document/template-overrides/
 * @author      Automattic
 * @package     wp-job-manager
 * @category    Template
 * @version     1.33.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

wp_enqueue_script( 'wp-job-manager-ajax-filters' );

do_action( 'job_manager_job_filters_before', $atts );
?>
<section class="job_search_section">
	<div class="container-fluid site-padding">
		<div class="row">
			<div class="col-lg-12">
				<h1>Job Search</h1>
			</div>
			<div class="col-lg-9">
					

				<form class="job_filters row">
					<?php do_action( 'job_manager_job_filters_start', $atts ); ?>

					<!-- <div class="search_jobs"> -->
						<?php do_action( 'job_manager_job_filters_search_jobs_start', $atts ); ?>

						<div class="search_keywords job_search_input_field col-lg-5">
							<input type="text" name="search_keywords" id="search_keywords" placeholder="Job title, keyword" value="<?php if(isset($_GET['keyword'])){echo $_GET['keyword'];} ?>" />
						</div>

						<div class="search_location job_search_input_field col-lg-7">
							<input type="text" name="search_location" id="search_location" placeholder="City, Town, Postal Code" value="<?php if(isset($_GET['location'])){echo $_GET['location'];} ?>" />
							<?php
							/**
							 * Show the submit button on the job filters form.
							 *
							 * @since 1.33.0
							 *
							 * @param bool $show_submit_button Whether to show the button. Defaults to true.
							 * @return bool
							 */
							if ( apply_filters( 'job_manager_job_filters_show_submit_button', true ) ) :
							?>
								<div class="search_submit">
									<input type="submit" value="<?php esc_attr_e( 'Search Jobs', 'wp-job-manager' ); ?>" class="btn btn-primary btn-search"> <!-- <i class='fas fa-arrow-right'></i> -->
								</div>
							<?php endif; ?>
						</div>

						<div style="clear: both"></div>

						<?php if ( $categories ) : ?>
							<?php foreach ( $categories as $category ) : ?>
								<input type="hidden" name="search_categories[]" value="<?php echo esc_attr( sanitize_title( $category ) ); ?>" />
							<?php endforeach; ?>
						<?php elseif ( $show_categories && ! is_tax( 'job_listing_category' ) && get_terms( [ 'taxonomy' => 'job_listing_category' ] ) ) : ?>
							<div class="search_categories">
								<label for="search_categories"><?php esc_html_e( 'Category', 'wp-job-manager' ); ?></label>
								<?php if ( $show_category_multiselect ) : ?>
									<?php job_manager_dropdown_categories( [ 'taxonomy' => 'job_listing_category', 'hierarchical' => 1, 'name' => 'search_categories', 'orderby' => 'name', 'selected' => $selected_category, 'hide_empty' => true ] ); ?>
								<?php else : ?>
									<?php job_manager_dropdown_categories( [ 'taxonomy' => 'job_listing_category', 'hierarchical' => 1, 'show_option_all' => __( 'Any category', 'wp-job-manager' ), 'name' => 'search_categories', 'orderby' => 'name', 'selected' => $selected_category, 'multiple' => false, 'hide_empty' => true ] ); ?>
								<?php endif; ?>
							</div>
						<?php endif; ?>

						

						<?php do_action( 'job_manager_job_filters_search_jobs_end', $atts ); ?>
					<!-- </div> -->
				</form>


			</div>
			<div class="col-lg-3">
				<form class="job_filters location_filter_form" id="location_search_form" action="<?php echo site_url(); ?>/jobs">
					<div class="search_sort job_search_input_field sort_field">
						<label for="sort">Sort By:</label>
						<select id="sort" name="sort" >
							<option value="position" selected>Position</option>
							<option value="date" selected>Date</option>
						</select>
					</div>
				</form>
			</div>
		</div>
	</div>
</section>
<?php do_action( 'job_manager_job_filters_after', $atts ); ?>

<noscript><?php esc_html_e( 'Your browser does not support JavaScript, or it is disabled. JavaScript must be enabled in order to view listings.', 'wp-job-manager' ); ?></noscript>
