<?php
/**
 * Content shown before job listings in `[jobs]` shortcode.
 *
 * This template can be overridden by copying it to yourtheme/job_manager/job-listings-start.php.
 *
 * @see         https://wpjobmanager.com/document/template-overrides/
 * @author      Automattic
 * @package     wp-job-manager
 * @category    Template
 * @version     1.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="container-fluid site-padding job_listings_margin">
	<div class="row">
		<div class="col-lg-4">
			<div class="sidebar">
				<h1>Check out the hottest new jobs just posted!</h1>
				<br>
				<ul class="latest-jobs-list">
					<?php
						$args = array( 
							'post_type'   => 'job_listing',
							'posts_per_page'=> 5,
							'orderby' => 'date',
							'order'   => 'date',
						);

						$query = new WP_Query( $args );
						while( $query->have_posts() ) : $query->the_post()
					?>
						<a href="<?=the_permalink();?>">
							<li class="latest-jobs-list-item">
								<i class="fas fa-arrow-right"></i> <?=the_title();?>
							</li>
						</a>

					<?php
						endwhile;
					?>
				</ul>
			</div>
			<div class="social-media">
				<ul class="social-media-icons text-sm-center">
					<?php while( have_rows('social_media_channels', 'options') ) : the_row(); ?>
					<a href="<?=get_sub_field('full_url');?>" target="_blank"><li><i class="<?= get_sub_field('fa5_icon_class'); ?>"></i></li></a>
					<?php endwhile; ?>
					<li class="socials-tagline">Keep up to date!</li>
				</ul>
			</div>
		</div>
		<div class="col-lg-8">
			
			<ul class="job_listings">