<?php
/**
 * Single job listing.
 *
 * This template can be overridden by copying it to yourtheme/job_manager/content-single-job_listing.php.
 *
 * @see         https://wpjobmanager.com/document/template-overrides/
 * @author      Automattic
 * @package     wp-job-manager
 * @category    Template
 * @since       1.0.0
 * @version     1.28.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $post;
?>
<div class="container-fluid site-padding page_y_margin">
	<div class="row">
		<div class="col-md-4">
			<div class="sidebar">
				<h1>Check out the hottest new jobs just posted!</h1>
				<br>
				<ul class="latest-jobs-list">
					<?php
						$args = array(
							'post_type'   => 'job_listing',
							'posts_per_page'=> 5,
							'orderby' => 'date',
							'order'   => 'DESC',
						);
						$latest_jobs = get_posts($args);
						foreach($latest_jobs as $job) { ?>
							<a href="<?= get_permalink($job->ID) ;?>">
								<li class="latest-jobs-list-item">
									<i class="fas fa-arrow-right"></i> <?= $job->post_title; ?>
								</li>
							</a>
						<?php
						}
					?>
						<a href="<?= get_permalink($job->ID) ;?>">
							<li class="latest-jobs-list-item">
								<i class="fas fa-arrow-right"></i> <?= $job->post_title; ?>
							</li>
						</a>
				</ul>
			</div>
			<div class="social-media">
				<ul class="social-media-icons text-sm-center">
					<?php while( have_rows('social_media_channels', 'options') ) : the_row(); ?>
					<a href="<?=get_sub_field('full_url');?>" target="_blank"><li><i class="<?= get_sub_field('fa5_icon_class'); ?>"></i></li></a>
					<?php endwhile; ?>
					<li class="socials-tagline">Keep up to date!</li>
				</ul>
			</div>
		</div>
		<div class="col-md-8">
			<div class="row">
				<div class="col-md-12">
					<div class="single_job_listing">
						<?php if ( get_option( 'job_manager_hide_expired_content', 1 ) && 'expired' === $post->post_status ) : ?>
							<div class="job-manager-info"><?php _e( 'This listing has expired.', 'wp-job-manager' ); ?></div>
						<?php else : ?>
						<div class="position">
							<h3><?php wpjm_the_job_title(); ?></h3>
						</div>
						<?php
							/**
							 * single_job_listing_start hook
							 *
							 * @hooked job_listing_meta_display - 20
							 * @hooked job_listing_company_display - 30
							 */
							do_action( 'single_job_listing_start' );
						?>
						<?php if ( candidates_can_apply() ) : ?>
							<?php get_job_manager_template( 'job-application.php' ); ?>
						<?php endif; ?>

						<div class="job_description">
							<?php wpjm_the_job_description(); ?>
						</div>

						<?php
							/**
							 * single_job_listing_end hook
							 */
							do_action( 'single_job_listing_end' );
						?>
						<?php endif; ?>
					</div>

				</div>
				<div class="col-md-12 link_to_listings">
					<a href="<?php echo site_url(); ?>/jobs">← Back To Listings</a>
				</div>
			</div>
			
		</div>
	</div>
</div>