<?php
/**
 * Job listing in the loop.
 *
 * This template can be overridden by copying it to yourtheme/job_manager/content-job_listing.php.
 *
 * @see         https://wpjobmanager.com/document/template-overrides/
 * @author      Automattic
 * @package     wp-job-manager
 * @category    Template
 * @since       1.0.0
 * @version     1.34.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $post;
?>
<li <?php job_listing_class(); ?> data-longitude="<?php echo esc_attr( $post->geolocation_long ); ?>" data-latitude="<?php echo esc_attr( $post->geolocation_lat ); ?>">
	<!-- <a href="<?php //the_job_permalink(); ?>"> -->
		<?php //the_company_logo(); ?>
		<div class="position">
			<h3><?php wpjm_the_job_title(); ?></h3>
		</div>
		<div class="location">
			<span class="job_listing_label">Location:</span> <?php the_job_location( false ); ?>
		</div>
		<div class="company">
			<span class="job_listing_label">Companyzzz:</span> <?php the_company_name(); ?>
			<?php //the_company_tagline( '<span class="tagline">', '</span>' ); ?>
		</div>
		<div class="job_listing_buttons">
			<a href="<?php the_job_permalink(); ?>" class="btn btn-primary">Job Details <i class="fas fa-arrow-right"></i></a>
			<a href="" class="btn btn-secondary">Apply Now <i class="fas fa-arrow-right"></i></a>
		</div>
	<!-- </a> -->
</li>
