const common = () => {
    console.log('This gets run on every page and is exported as the default funciton. This will require a function call to run');
};

console.log('Any plain javascript will instantly run from an imported file');

export default common;

$(document).ready(function(){
    $('.testimonials-sect-container').slick({
        arrows: false,
        dots: true,
        dotsClass: 'pagination-dots testimonial-dots',
        infinite: false,
    });
    $('.testimonial-container').slick({
        arrows: false,
        dots: true,
        dotsClass: 'pagination-dots',
        infinite: false,
    });
    $('.news-slider').slick({
        arrows: false,
        dots: true,
        dotsClass: 'pagination-dots center-dots',
        infinite: false,
    });
});

$('#hamburger-menu').on("click", function(event) {
    document.getElementById("dropdown-nav-overlay").classList.toggle("hide");
    document.getElementById("dropdown-nav").classList.toggle("dropdown-nav-open");
});

$('#sort').on( "change", function(event) {
    let select = $(this).val();

    let keyword = $('#search_keywords').val();
    let location = $('#search_location').val();

    const formData = new FormData();
    formData.append('select', select);
    formData.append('search_keywords', keyword);
    formData.append('search_location', location);
    formData.append('action', 'filterJobs');
    formData.append('nonce', neilsonAjax.nonce);

    $.ajax({
        url: neilsonAjax.url,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function() {
            $('ul.job_listings').addClass('loading');
            // $('ul.job_listings').children('li').css("visibility", "hidden");
            $('ul.job_listings').empty();
        },
        success : function( response ) {
            $('ul.job_listings').append(response.data);
            // $('ul.job_listings').children('li').css("visibility", "visible");
            $('ul.job_listings').removeClass('loading');
        }
    });
    event.preventDefault();   
});