<?php
$bgImage = get_sub_field('background_image');
$bgColour = get_sub_field('background_colour');
$bgType = get_sub_field('background_type');
$bookingText = get_sub_field('booking_text');
$bookingTextColour = get_sub_field('booking_text_colour');

if(empty($bookingTextColour)) {
    $bookingTextColour = '#FFFFFF';
}

if(empty($bookingText)) {
    $bookingText = 'Check Availability Now with our partners Hoseasons';
}

if($bgType == 'image') {
    $bgStyle = "background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('" . $bgImage . "');";
}

if ($bgType == 'colour') {
    $bgStyle = 'background-color:' . $bgColour . ';';
}
?>

<section class="hoseasons-lodge-search-form" style="<?= $bgStyle; ?>">
    <div class="container">
        <div class="heading-text mx-auto" style="color: <?= $bookingTextColour; ?>;">
            <p><?= $bookingText; ?></p>
        </div>

        <form role="search" class="mx-auto row row-cols-lg-auto g-3 align-items-center lodge-search" method="get" action="https://booking.hoseasons.co.uk/ruthven-falls-lodges/lodges/rfhp">
            <div class="col-12 inner-sections date-container">
                <div class="text-container">
                    <label for="date">Date</label>
                    <input type="text" id="date" name="date">
                </div>
            </div>

            <div class="col-12 inner-sections night-container">
                <div class="select-container">
                    <label for="nights">Duration</label>
                    <select id="nights" name="nights" class="minimal">
                        <option value="1">1 night</option>
                        <option value="2">2 nights</option>
                        <option value="3">3 nights</option>
                        <option value="4">4 nights</option>
                        <option value="5">5 nights</option>
                        <option value="6">6 nights</option>
                        <option selected="selected" value="7">7 nights</option>
                        <option value="14">14 nights</option>
                        <option value="21">21 nights</option>
                    </select>
                </div>
            </div>

            <div class="col-12 inner-sections range-container">
                <div class="select-container">
                    <label for="range">Flexibility</label>
                    <select id="range" name="range" class="minimal">
                        <option value="0">Exact</option>
                        <option value="7">+/- 7 days</option>
                        <option selected="selected" value="3">+/- 3 days</option>
                    </select>
                </div>
            </div>

            <div class="col-12 inner-sections adults-container">
                <div class="select-container">
                    <label for="adult">Adults</label>
                    <select id="adult" name="adult" class="minimal">
                        <option value="1">1</option>
                        <option selected="selected" value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5</option>
                        <option value="6">6</option>
                    </select>
                </div>
            </div>

            <div class="col-12 inner-sections child-container">
                <div class="select-container">
                    <label for="child">Children</label>
                    <select id="child" name="child" class="minimal">
                        <option selected="selected" value="0">0</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5</option>
                    </select>
                </div>
            </div>

            <div class="col-12 inner-sections infant-container">
                <div class="select-container">
                    <label for="infant">Babies</label>
                    <select id="infant" name="infant" class="minimal">
                        <option selected="selected" value="0">0</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5</option>
                        <option value="6">6</option>
                    </select>
                </div>
            </div>

            <div class="col-12 inner-sections pet-container">
                <div class="select-container last-select">
                    <label for="pets">Pets</label>
                    <select id="pets" name="pets" class="minimal">
                        <option selected="selected" value="0">0</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                    </select>
                </div>
            </div>

            <div class="col-12 lodge-search-button">
                <button type="submit" formtarget="_blank" class="btn btn-primary">Search</button>
            </div>

            <input type="hidden" name="lodge_search" value="1">
            <input type="hidden" name="s">
        </form>
    </div>
</section>