<?php
use Blue2\Scruffy\Controllers\SiteController;
$footerLogo = get_field('footer_logo', 'options');
$footerLogoSecondary = get_field('footer_logo_secondary', 'options');
?>

<footer class="site-footer">
    <?php
    if(!is_page( 'get-in-touch' )) { ?>
        <div class="container-fluid">
            <div class="row">
                <div class="sign-up-form">
                    <div class="col-md-6 mx-auto text-center">
                        <?= do_shortcode(' [ninja_form id=7]'); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    
    <div class=" footer-bottom">
        <div class="container-xxl">
            <div class="row top-section">
                <div class="col-lg-7">
                    <div class="row">
                        <div class="col-lg-4 col-10 footer-logo">
                            <div class="band-logo--footer">
                            <?php

                            if( !empty( $footerLogo ) ): ?>
                                <img src="<?php echo esc_url($footerLogo['url']); ?>" alt="<?php echo esc_attr($footerLogo['title']); ?>" height="100px" />
                            <?php else: ?>
                                <img src="" height="100px" />
                            <?php endif; ?>
                            </div>
                            <?php
                            if($footerLogoSecondary){
                                ?>
                                <div class="logo-secondary--footer">
                                    <img src="<?php echo esc_url($footerLogoSecondary['url']); ?>" alt="<?php echo esc_attr($footerLogoSecondary['title']); ?>" height="100px" />
                                </div>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="col-lg-3 col-5 quick-links">
                            <p class="menu-title">Quick Links</p>

                            <?php
                                wp_nav_menu( 
                                    [
                                        'theme_location' => 'quick_links',
                                        'menu_class' => 'quick-links-menu'
                                    ]
                                );
                            ?>
                        </div>

                        <div class="col-lg-3 col-5 help-links">
                            <p class="menu-title">Help Links</p>

                            <?php
                                wp_nav_menu( 
                                    [
                                        'theme_location' => 'help_links',
                                        'menu_class' => 'help-links-menu'
                                    ]
                                );
                            ?>
                        </div>

                        <div class="col-10 newsletter-signup-container">
                            <p>Want to join our newsletter? <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal"><span>Click Here</span></a></p>
                        </div>

                        <div class="newsletter-modal">
                             <!-- Newsletter signup Modal -->
                             <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <?= '<script type="text/javascript" src="//app.icontact.com/icp/core/mycontacts/signup/designer/form/automatic?id=266&cid=1137618&lid=6997"></script>'; ?>
                                    </div>
                                    <div class="modal-footer">
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-10 footer-address">
                    <div class="address">
                        <?php 
                        $companyName = get_field('company_name', 'options'); 
                        $companyAddress = get_field('company_address', 'options');
                        $companyEmail = get_field('contact_email_address', 'options');
                        $companyPhone = get_field('contact_phone_number', 'options');
                        ?>

                        <p><?= $companyName; ?></p>
                        <div><?= $companyAddress; ?></div>
                        Tel: <?= $companyPhone; ?><br>
                        Email: <?= $companyEmail; ?><br>
                    </div>

                    <div class="socials">
                        <?php if (have_rows('social_media_channels', 'option')) { ?>
                            <ul class="footer-socials">
                                <?php
                                while (have_rows('social_media_channels', 'option')) {
                                    the_row(); ?>
                                    <li><a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a></li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <div class="row bottom-section">
                <div class="col-lg-5 col-10 legal">
                    <p class="copyright-text">Copyright &copy; <?php SiteController::auto_copyright('2021'); ?> <?= get_bloginfo( 'name' ); ?></p>
                    
                    <?php
                        wp_nav_menu( 
                            [
                                'theme_location' => 'legal_links',
                                'menu_class' => 'legal-links'
                            ]
                        );
                    ?>
                </div>

                <div class="col-lg-5 col-10 powered-by">
                    <P class="powered-by-text text-end">Website Powered By <a href="https:www.blue2.com">Blue2</a>
                </div>
            </div>
        </div>
    </div>
</footer>