<?php
$additionalClasses='';
$slideshow = get_field('multiple_slides');
if($slideshow){
    $slides = get_field('slides');
}else{
    $useVideo = get_field('use_video_for_banner');
}
if(!$slideshow){
    if(get_field( "banner_image" )) {
        $bannerImage = wp_get_attachment_url( get_field( "banner_image" ) , 'banner' );
    } else {
        $bannerImage = '';
    }
    if($useVideo){
        $bannerVideo = get_field('banner_video_from_url');
    }
}
$bannerAlign =  get_field( "content_position" );
$bannerText = get_field('banner_text');

$removePaddingTop = get_field('remove_padding_top');
$removePaddingBottom = get_field('remove_padding_bottom');

$removeTop = '';
$removeBottom = '';

if($removePaddingTop) {
    $removeTop = 'removeTop';
}

if($removePaddingBottom) {
    $removeBottom = 'removeBottom';
}

if(get_field("banner_height")) {
    $bannerHeight =  get_field("banner_height");
} else {
    $bannerHeight = '790';
}
if($useVideo && $bannerVideo){
    $additionalClasses.=' banner--video';
    $aspect_ratio_padding = get_field('aspect_ratio_padding') ?: '56.2';
}
$group = get_field('banner_content');
if($group){
    $bannerText = $group['banner_text'];
    $ctas = $group['call_to_action_buttons'];
}
?>

<section class="banner-section <?= $removeTop; ?> <?= $removeBottom; ?>">
<?php 
    if(!$slideshow){
?>
    <div class="jumbotron jumbotron-fluid banner<?=$additionalClasses;?>" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $bannerImage; ?>'); height: <?= $bannerHeight; ?>px; padding-bottom:<?= $aspect_ratio_padding.'%'; ?>;">
    <?php
    if($useVideo && $bannerVideo){
        ?>
        <div class="embed-container">
            <?php 
            // Use preg_match to find iframe src.
            preg_match('/src="(.+?)"/', $bannerVideo, $matches);
            $src = $matches[1];
            
            // Add extra parameters to src and replace HTML.
            $params = array(
                'mute' => 1,
                'autoplay'  => 1
            );
            $new_src = add_query_arg($params, $src);
            $bannerVideo = str_replace($src, $new_src, $bannerVideo);
            
            // Add extra attributes to iframe HTML.
            $attributes = 'frameborder="0"';
            $bannerVideo = str_replace('></iframe>', ' ' . $attributes . '></iframe>', $bannerVideo);
            
            // Display customized HTML.
            echo $bannerVideo;?>  
        </div>
        <?php
    }
    ?>
        <div class="container banner-content <?= $bannerAlign; ?>">
            <?php if($bannerText){?>
            <h1 class="display-5 banner-header text-center"><?= $bannerText; ?></h1>
            <?php
                }
            ?>
                                    
            <?php if ($ctas) { ?>
                <p class="lead">
                    <ul class="cta-btn-row">
                        <?php foreach($ctas as $ctaBtns )  {
                            $ctaBtn = $ctaBtns['button']; ?>
                            <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                            <?php
                        } ?>
                    </ul>
                </p>
            <?php } ?>
        </div>
    </div>
<?php 
    }else{
        ?>
        <div class="swiper">
          <!-- Additional required wrapper -->
          <div class="swiper-wrapper">
            <!-- Slides -->
            <?php 
            foreach ($slides as $slide){
                $slideContents = $slide['slide_content'];
            ?>
            <div class="swiper-slide jumbotron jumbotron-fluid banner" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $slide['slide_image']['sizes']['banner']; ?>');">
                <div class="container banner-content <?= $bannerAlign; ?>">
                    <h1 class="display-5 banner-header text-center"><?= $slideContents['slide_text']; ?></h1>
                
                    <?php if ($slideContents['call_to_action_buttons']) { ?>
                        <p class="lead">
                            <ul class="cta-btn-row">
                                <?php foreach($slideContents['call_to_action_buttons'] as $ctaBtns )  {
                                    $ctaBtn = $ctaBtns['button']; ?>
                                    <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                    <?php
                                } ?>
                            </ul>
                        </p>
                    <?php } ?>
                </div>
            </div>
            <?php
                }
            ?>
          </div>
          <!-- If we need navigation buttons -->
          <div class="swiper-button-prev"></div>
          <div class="swiper-button-next"></div>
        </div>
        <?php
    }
?>
</section>
