const common = () => {
    console.log('This gets run on every page and is exported as the default funciton. This will require a function call to run');

    $('.hamburger').on('click', function() {
        $( this ).toggleClass( "open" );
        $('.menu-overlay').toggleClass('--open');
        $('body').toggleClass('noscroll');
    });

    $(window).on('resize', function(e) {
        if ($(window).width() >= 1150) {
            $('body').addClass('desktop');
        } else if ($(window).width() >= 900) {
            $('body').addClass('tablet');
        } else if ($(window).width() <= 600) {
            $('body').addClass('mobile');
        }
    });

    $(function(e){
        $(window).trigger('resize');

        $('.lodge-link').on('click', function() {
            //remove all active classes
            $(".lodge").removeClass('active');
            //add active class to current object
            $(this).parent('.lodge').addClass('active');
        });

        $('.lodge-link').on('mouseenter', function(){
            $(this).parent('.lodge').addClass('hover');
        });

        $('.lodge-link').on('mouseleave', function(){
            $(".lodge").removeClass('hover');
        });

        $('.close').on('click', function() {
            //remove all active classes
            $(".lodge").removeClass('active');
        });
    });

    var $slider = $('.slider');

    $slider.each(function() {        
        var slidesToShow = $(this).data('slidestoshow') ? $(this).data('slidestoshow') : 3;

        $(this).on('init', function(event, slick) {
            var count = slick.slideCount;
            var slidesToShow = slick.options.slidesToShow;

            if( count > slidesToShow ) {
                $(this).parent('.slider-content').find('.bar').width($(this).parent('.slider-content').find('.progress').width() / count);
                $(this).parent('.slider-content').find('.progress').show();
            }

            $(this).find('.slick-prev').addClass('disabled');
        });
        
        $(this).on('beforeChange', function(event, slick, currentSlide, nextSlide) {   
            var count = slick.slideCount;
            var stepCounter = nextSlide;
            var slidesToShow = slick.options.slidesToShow;

            if( count > slidesToShow ) {
                var wl = $(this).parent('.slider-content').find('.progress').width() / count;
                $(this).parent('.slider-content').find('.bar').css('left', wl * stepCounter);
                $(this).parent('.slider-content').find('.progress').show();
            }
        });

        $(this).on('afterChange', function (event, slick, currentSlide) {
            var count = slick.slideCount;

            if(currentSlide === count-1) {
                $(this).find('.slick-next').addClass('disabled');
            }
            else {
                $(this).find('.slick-next').removeClass('disabled');
            }

            if(currentSlide === 0) {
                $(this).find('.slick-prev').addClass('disabled');
            }
            else {
                $(this).find('.slick-prev').removeClass('disabled');
            }  
        });
        
        $(this).slick({
            slidesToShow: slidesToShow,
            slidesToScroll: 1,
            nextArrow: '<div class="slider-button-next slick-next" tabindex="0" role="button" aria-label="Next slide" aria-disabled="false"><i class="fas fa-chevron-right"></i></div>',
            prevArrow: '<div class="slider-button-prev slick-prev" tabindex="-1" role="button" aria-label="Previous slide" aria-disabled="true"><i class="fas fa-chevron-left"></i></div>',
            speed: 400,
            responsive: [
                {
                    breakpoint: 1150,
                    settings: 
                    {
                        slidesToShow: 3,
                    }
                },
                {
                    breakpoint: 900,
                    settings: {
                        slidesToShow: 2,
                    }
                },
                {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 1,
                    }
                }
            ]
        }); 
    }); 

    $(".nav-call-to-action").on('click', function() {
        window.location = $(this).find("a").attr("href"); 
        return false;
    });

    $(function() {
        var minDate = new Date((new Date()).valueOf() + 1000*3600*24);
        $('#date').datepicker({
            defaultDate: minDate,
            minDate: minDate
        }).datepicker('setDate', minDate);
    });
};

console.log('Any plain javascript will instantly run from an imported file');

export default common;
