<?php 
    $companyEmail = get_field('contact_email_address', 'options');
    $companyPhone = get_field('contact_phone_number', 'options');
?>                        
<header class="header-container">
    <div class="container-fluid">
        <div class="row header-navbar">
            <div class="col-2 nav-menu">
                <div class="hamburger">
                    <div class="burger-menu">
                        <div class="bars"></div>
                    </div>
                    <div class="burger-title">
                        <span>Menu</span>
                    </div>
                </div>
            </div>

            <div class="col-2 d-none d-md-flex nav-left-link">
                <?php $leftLink = get_field('left_navbar_link', 'options'); 
                
                if( $leftLink ): 
                    $link_url = $leftLink['url'];
                    $link_title = $leftLink['title'];
                    $link_target = $leftLink['target'] ? $link['target'] : '_self';
                ?>
                    <a class="<?php if( is_page( $link_title ) ) : ?>active<?php endif; ?>" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php else: ?>
                    <a href="" target=""></a>
                <?php endif; ?>
            </div>

            <div class="col-6 col-md-2 nav-logo">
                <?php $navLogo = get_field('navbar_logo', 'options');

                if( !empty( $navLogo ) ): ?>
                    <a href="/"><img class="mx-auto nav-logo-image" src="<?php echo esc_url($navLogo['url']); ?>" alt="<?php echo esc_attr($navLogo['alt']); ?>" height="75" /></a>
                <?php else: ?>
                    <a href="/"><img class="mx-auto nav-logo-image" src="<?= get_template_directory_uri() . '/dist/images/MLV-1-6-21-grey-yellow-white.png'; ?>" alt="Morris leslie Villages Logo" height="75" /></a>
                <?php endif; ?>
            </div>

            <div class="col-2 d-none d-md-flex nav-right-link">
                <?php $rightLink = get_field('right_navbar_link', 'options'); 

                if( $rightLink ): 
                    $link_url = $rightLink['url'];
                    $link_title = $rightLink['title'];
                    $link_target = $rightLink['target'] ? $link['target'] : '_self';
                ?>
                
                    <a class="<?php if( is_page( $link_title ) ) : ?>active<?php endif; ?>" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php else: ?>
                    <a href="" target=""></a>
                <?php endif; ?>
            </div>

            <div class="col-2 nav-call-to-action">
                <?php $ctaLink = get_field('nav_cta', 'options'); 

                if( $ctaLink ): 
                    $link_url = $ctaLink['url'];
                    $link_title = $ctaLink['title'];
                    $link_target = $ctaLink['target'] ? $link['target'] : '_self';
                ?>
                    <i class="fas fa-hotel d-block d-md-none"></i>
                    <a class="<?php if( is_page( $link_title ) ) : ?>active<?php endif; ?>" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                <?php else: ?>
                    <a href="" target=""></a>
                <?php endif; ?>
            </div>
        </div>
        <div class="row header--contact">
            <div class="col col-sm-5 col-lg-4">
                <a href="tel:<?=$companyPhone;?>"><span class="fa fa-phone"></span> <?=$companyPhone;?></a>
            </div>
            <div class="col  col-sm-5 offset-lg-2 col-lg-4">
                <a href="mailto:<?=$companyEmail;?>"><span class="fa fa-envelope"></span> <?=$companyEmail;?></a>
            </div>
        </div>
    </div>

    <?php
        $overlayBG = get_field('menu_overlay_image', 'options');
    ?>

    <div class="menu-overlay" style="background-image:url('<?= $overlayBG; ?>')">
        <div class="overlay-contents">
            <?php 
                wp_nav_menu( 
                    [
                        'theme_location' => 'main_menu',
                        'menu_class' => 'overlay-menu'
                    ]
                ); 
            ?>

            <form action="/" method="get">
                <div class="input-group">
                    <input class="form-control py-2 border-end-0 border rounded-start" type="search" placeholder="Search" id="search-input" name="s" value="<?php the_search_query(); ?>">
                    <span class="input-group-append">
                        <div class="input-group-text bg-white rounded-end">
                            <i class="fa fa-search"></i>
                        </div>
                    </span>
                </div>
            </form>

            <div class="overlay-social-navigation">
                <?php if (have_rows('social_media_channels', 'option')) { ?>
                    <ul class="overlay-navigation">
                        <?php
                        while (have_rows('social_media_channels', 'option')) {
                            the_row(); ?>
                            <li><a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        </div>
    </div>

    <?php if(is_page() || is_singular()) {
        if(get_field( "banner_image" )) {
            $bannerImage = wp_get_attachment_url( get_field( "banner_image" ) , 'banner' );
            $gotBannerImage = true;
        } else {
            $bannerImage = '';
            $gotBannerImage = false;
        }
    
        if(get_field( "content_position" )) {
            $bannerAlign =  get_field( "content_position" );
        }

        $group = get_field('banner_content');
    } else if(is_search()) {
        if (isset($_GET['lodge_search']) && $_GET['lodge_search'] == 1) {
            if(get_field( "lodge_search_banner_image",'option' )) {
                $bannerImage = wp_get_attachment_url( get_field( "lodge_search_banner_image",'option' ) , 'banner' );
                $gotBannerImage = true;
            } else {
                $bannerImage = '';
                $gotBannerImage = false;
            }
        
            if(get_field( "lodge_search_content_position",'option' )) {
                $bannerAlign =  get_field( "lodge_search_content_position",'option' );
            }

            if(get_field( "lodge_search_banner_height",'option' )) {
                $bannerHeight =  get_field("lodge_search_banner_height",'option' );
            } else {
                $bannerHeight = '790';
            }
    
            $group = get_field('lodge_search_banner_content','option');
        } else {
            if(get_field( "search_banner_image",'option' )) {
                $bannerImage = wp_get_attachment_url( get_field( "search_banner_image",'option' ) , 'banner' );
                $gotBannerImage = true;
            } else {
                $bannerImage = '';
                $gotBannerImage = false;
            }
        
            if(get_field( "search_content_position",'option' )) {
                $bannerAlign =  get_field( "search_content_position",'option' );
            }

            if(get_field("search_banner_height",'option' )) {
                $bannerHeight =  get_field("search_banner_height",'option' );
            } else {
                $bannerHeight = '790';
            }
    
            $group = get_field('search_banner_content','option');
        }
    } else if(is_404()) {
        if(get_field( "404_banner_image",'option' )) {
            $bannerImage = wp_get_attachment_url( get_field( "404_banner_image",'option' ) , 'banner' );
            $gotBannerImage = true;
        } else {
            $bannerImage = '';
            $gotBannerImage = false;
        }
    
        if(get_field( "404_content_position",'option' )) {
            $bannerAlign =  get_field( "404_content_position",'option' );
        }

        if(get_field( "404_banner_height",'option' )) {
            $bannerHeight =  get_field("404_banner_height",'option' );
        } else {
            $bannerHeight = '790';
        }

        $group = get_field('404_banner_content','option');
    } else {
        $term = get_queried_object();
        
        if(get_field( "banner_image", $term )) {
            $image = get_field( "banner_image", $term );
            $bannerImage = wp_get_attachment_url( $image, 'banner' );
            $gotBannerImage = true;
        } else {
            $bannerImage = '';
            $gotBannerImage = false;
        }
    
        if(get_field( "content_position", $term )) {
            $bannerAlign =  get_field( "content_position", $term );
        }

        if(get_field( "banner_height",'option' )) {
            $bannerHeight =  get_field("banner_height",'option' );
        } else {
            $bannerHeight = '790';
        }

        $group = get_field('banner_content', $term);
    }

    if( $gotBannerImage || $group['banner_text'] || $group['call_to_action_buttons']) {
        //we have content, now run the rows
        if(is_page() || is_singular()) {
            if (have_rows('banner_content')) { ?>
                <div class="jumbotron jumbotron-fluid banner" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $bannerImage; ?>'); height: <?= $bannerHeight; ?>px;">
                    <div class="container banner-content <?= $bannerAlign; ?>">
                        <?php while (have_rows('banner_content')) {
                            the_row(); 
                            $bannerText = get_sub_field('banner_text');
                            ?>
        
                            <h1 class="display-5 banner-header text-center"><?= $bannerText; ?></h1>
        
                            <?php if (have_rows('call_to_action_buttons')) { ?>
                                <p class="lead">
                                    <ul class="cta-btn-row">
                                        <?php while (have_rows('call_to_action_buttons')) {
                                            the_row();
                                            $ctaBtn = get_sub_field('button'); ?>
                                            <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                            <?php
                                        } ?>
                                    </ul>
                                </p>
                                <?php
                            } ?>
                        <?php } ?>
                    </div>
                </div>
            <?php }
        } else if( is_search() ) {
            if (isset($_GET['lodge_search']) && $_GET['lodge_search'] == 1) {
                if (have_rows('lodge_search_banner_content', 'option')) { ?>
                    <div class="jumbotron jumbotron-fluid banner" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $bannerImage; ?>');  height: <?= $bannerHeight; ?>px;">
                        <div class="container banner-content <?= $bannerAlign; ?>">
                            <?php while (have_rows('lodge_search_banner_content','option')) {
                                the_row(); 
                                $bannerText = get_sub_field('banner_text','option');
                                ?>
            
                                <h1 class="display-5 banner-header text-center"><?= $bannerText; ?></h1>
            
                                <?php if (have_rows('call_to_action_buttons','option')) { ?>
                                    <p class="lead">
                                        <ul class="cta-btn-row">
                                            <?php while (have_rows('call_to_action_buttons','option')) {
                                                the_row();
                                                $ctaBtn = get_sub_field('button','option'); ?>
                                                <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                                <?php
                                            } ?>
                                        </ul>
                                    </p>
                                    <?php
                                } ?>
                            <?php } ?>
                        </div>
                    </div>
                <?php }
            } else {
                if (have_rows('search_banner_content', 'option')) { ?>
                    <div class="jumbotron jumbotron-fluid banner" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $bannerImage; ?>'); height: <?= $bannerHeight; ?>px;">
                        <div class="container banner-content <?= $bannerAlign; ?>">
                            <?php while (have_rows('search_banner_content', 'option')) {
                                the_row(); 
                                $bannerText = get_sub_field('banner_text', 'option');
                                ?>
            
                                <h1 class="display-5 banner-header text-center"><?= $bannerText; ?></h1>
            
                                <?php if (have_rows('call_to_action_buttons', 'option')) { ?>
                                    <p class="lead">
                                        <ul class="cta-btn-row">
                                            <?php while (have_rows('call_to_action_buttons', 'option')) {
                                                the_row();
                                                $ctaBtn = get_sub_field('button', 'option'); ?>
                                                <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                                <?php
                                            } ?>
                                        </ul>
                                    </p>
                                    <?php
                                } ?>
                            <?php } ?>
                        </div>
                    </div>
                <?php }
            }
        } else if( is_404() ) {
            if (have_rows('404_banner_content', 'option')) { ?>
                <div class="jumbotron jumbotron-fluid banner" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $bannerImage; ?>'); height: <?= $bannerHeight; ?>px;">
                    <div class="container banner-content <?= $bannerAlign; ?>">
                        <?php while (have_rows('404_banner_content', 'option')) {
                            the_row(); 
                            $bannerText = get_sub_field('banner_text', 'option');
                            ?>
        
                            <h1 class="display-5 banner-header text-center"><?= $bannerText; ?></h1>
        
                            <?php if (have_rows('call_to_action_buttons', 'option')) { ?>
                                <p class="lead">
                                    <ul class="cta-btn-row">
                                        <?php while (have_rows('call_to_action_buttons', 'option')) {
                                            the_row();
                                            $ctaBtn = get_sub_field('button', 'option'); ?>
                                            <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                            <?php
                                        } ?>
                                    </ul>
                                </p>
                                <?php
                            } ?>
                        <?php } ?>
                    </div>
                </div>
            <?php }
        } else {
            if (have_rows('banner_content', $term)) { ?>
                <div class="jumbotron jumbotron-fluid banner" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $bannerImage; ?>'); height: <?= $bannerHeight; ?>px;">
                    <div class="container banner-content <?= $bannerAlign; ?>">
                        <?php while (have_rows('banner_content', $term)) {
                            the_row(); 
                            $bannerText = get_sub_field('banner_text', $term);
                            ?>
        
                            <h1 class="display-5 banner-header text-center"><?= $bannerText; ?></h1>
        
                            <?php if (have_rows('call_to_action_buttons', $term)) { ?>
                                <p class="lead">
                                    <ul class="cta-btn-row">
                                        <?php while (have_rows('call_to_action_buttons', $term)) {
                                            the_row();
                                            $ctaBtn = get_sub_field('button', $term); ?>
                                            <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                            <?php
                                        } ?>
                                    </ul>
                                </p>
                                <?php
                            } ?>
                        <?php } ?>
                    </div>
                </div>
            <?php }
        }
    } ?>
</header>

<main id="content">