<?php
//get our lodge information
$bedrooms = get_field('number_of_bedrooms');
$bathrooms = get_field('number_of_bathrooms');
$tel = get_field('telephone_number');
$locations = get_field('available_locations');
$price = get_field('lodge_price');
$hideEnquiry = get_field('hide_enquire_button');
$enquireLink = get_field('enquire_button_link');
$beforePrice = get_field('price_subtitle');
$type = get_field('lodge_type');

if( $enquireLink ):
    $link_url = $enquireLink['url'];
    $link_title = $enquireLink['title'];
    $link_target = $enquireLink['target'] ? $link['target'] : '_self';
else :
    $link_url = '';
    $link_title = 'Enquire';
    $link_target = '_self';
endif;
?>

<div <?php post_class("lodge-single"); ?>>
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-3 col-lg-2">
                <h3>Overview</h3>

                <div class="overview-items">
                    <div class="overview-item"><span>Lodge Type:</span>  <?= $type; ?></div>
                    <div class="overview-item"><span>Bedrooms:</span>  <?= $bedrooms; ?></div>
                    <div class="overview-item"><span>Bathrooms:</span>  <?= $bathrooms; ?></div>
                </div>
                <?php if(!$hideEnquiry) { ?>
                    <div class="overview-enquiry">
                        <a class="btn btn-primary" href="<?= $link_url; ?>"><span><?= $link_title; ?></span></a>
                    </div>
                <?php } ?>
            </div>
            <div class="col-md-7 col-lg-8">

                <div class="top-section">
                    <h1 class="fw-bold"><?= get_the_title();?></h1>
                    <div class="price-from"><span><?= $beforePrice; ?></span><h2 class="fw-bold"><?= $price; ?></h2></div>
                </div>

                <div class="single-content-container">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
    </div>

    <?php
    if(get_field('sections')) { ?>
        <div class="flexible-layout">
          <?php Blue2\Scruffy\Utils::flexibleLoop('sections'); ?>
        </div>
    <?php } ?>
</div>
