<?php

use Blue2\Scruffy\Controllers\MapController;

$term = basename($_SERVER['REQUEST_URI']);

$sitePlan = get_field($term . '-site-map' , 'options');
$locationMap = get_field($term . '-location' , 'options');
$matterport = get_field($term . '-matterport-code' , 'options');
$lodges = [ 
    'esk' => 365,
    'earn' => 364,
    'tweed' => 296
];

$args = array(  
    'post_type' => 'plot',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'tax_query' => array(
        array(
            'taxonomy' => 'locations',
            'field' => 'slug',
            'terms' => $term
        )
    )
);

$plots = new WP_Query( $args );

$lodgeInfo = Blue2\Scruffy\Controllers\MapController::getLodgeInfo($term);
?>

<section class="location-tab-section">
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-10">
                <ul class="nav nav-tabs" id="locationTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="lodges-for-sale-tab" data-bs-toggle="tab" data-bs-target="#lodges-for-sale" type="button" role="tab" aria-controls="lodges-for-sale" aria-selected="true">Lodges for Sale</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="site-plan-tab" data-bs-toggle="tab" data-bs-target="#site-plan" type="button" role="tab" aria-controls="site-plan" aria-selected="false">Site Plan</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="walkthrough-tab" data-bs-toggle="tab" data-bs-target="#walkthrough" type="button" role="tab" aria-controls="walkthrough" aria-selected="false">3D Walkthrough</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="lodge-availability-tab" data-bs-toggle="tab" data-bs-target="#lodge-availability" type="button" role="tab" aria-controls="lodge-availability" aria-selected="false">Lodge Availability</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="location-tab" data-bs-toggle="tab" data-bs-target="#location" type="button" role="tab" aria-controls="location" aria-selected="false">Location</button>
                    </li>
                </ul>
                <div class="tab-content" id="locationTabContent">
                    <div class="tab-pane fade show active" id="lodges-for-sale" role="tabpanel" aria-labelledby="lodges-for-sale-tab">
                        <div class="container-fluid for-sale-tab-container">
                            <div class="row">
                                <div class="slider-content container-xxl">
                                    <div class="slider">
                                        <?php foreach($lodges as $lodge => $id) { 
                                            $image = get_the_post_thumbnail_url( $id, 'lodgeSlider');
                                            $locations = get_the_terms( $id, 'locations' );
                                            $location = $locations[0]->name;
                                            $location_id = get_cat_ID($location);
                                            $location_link = get_category_link( $location_id );
                                            $lodge = get_the_title( $id );
                                            $price = get_field('lodge_price', $id);
                                            ?>
                                            <div>
                                                <a href="<?= get_page_link( $id); ?>"><div class="lodge slider-card" style="background-image: linear-gradient(rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), url('<?= $image; ?>');">
                                                    <div class="lodge-location">
                                                        <?= $location; ?>
                                                    </div>
                                                    <div class="lodge-title">
                                                        <h4><?= $lodge; ?></h4>
                                                    </div>
                                                    <div class="lodge-price">
                                                        <p>Priced from </p>&nbsp;<h5><?= $price; ?></h5>
                                                    </div>
                                                </div></a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <div class="progress">
                                        <div class="bar"></div>
                                    </div>
                                </div>
                            </div>
                        </div>                                    
                    </div>
                    <div class="tab-pane fade" id="site-plan" role="tabpanel" aria-labelledby="site-plan-tab">
                        <section class="area-map">
                            <img class="map img-fluid" src="<?= $sitePlan; ?>" alt="Map of location" />
                            <div class="lodge-pins">
                                <?php while ( $plots->have_posts() ) : $plots->the_post();
                                    $saleStatus = get_field('plot_status', get_the_ID());
                                    $saleDescription = get_field('sale_description');
                                    $locations = get_the_terms( get_the_ID(), 'locations' );
                                    $location = $locations[0]->name;
                                    $image = get_field('sale_image', get_the_ID());
                                    $title = get_the_title();
                                    $plotType = get_field('lodge_type', get_the_ID());
                                    $plotNumber = get_field('plot_number', get_the_ID());
                                    $price = get_field('lodge_price', get_the_ID());
                                    $mapLink = get_field('2d_read_more_button');

                                    if( $mapLink ): 
                                        $linkURL = $mapLink['url'];
                                        $linkTitle = $mapLink['title'];
                                        
                                    else :
                                        $linkURL = get_permalink();
                                        $linkTitle = 'Read More';
                                    endif;

                                    if($saleStatus == 'sale') {
                                        $status = 'Availabe';
                                    } elseif ($saleStatus == 'reserve') {
                                        $status = 'Reserved';
                                    } else {
                                        $status = 'Sold';
                                    }
                                    if(isset($plotNumber) && isset($plotType))
                                    { ?>
                                        <figure class="lodge lodge-<?= strtolower($plotType); ?>">
                                            <a class="lodge-link" href="#" onclick="return false;" style="left: <?= $lodgeInfo[$plotNumber]['left']; ?>; top: <?= $lodgeInfo[$plotNumber]['top']; ?>; transform: rotate(<?= $lodgeInfo[$plotNumber]['rotate']; ?>);">
                                                <img class="img-fluid" src="<?=get_template_directory_uri();?>/dist/images/target-<?= strtolower($plotType); ?>.svg" alt="target pin" />
                                            </a>
                                            <figcaption class="lodge-detail">
                                                <div class="lodge-sticky-panel">
                                                    <div class="close"><i class="fas fa-times"></i></div>
                                                    <img class="img-fluid" src="<?= $image; ?>" alt="For Sale Image" />

                                                    <div class="sale-info">

                                                        <span class="sale-title"><?= $title; ?> - <?= $location; ?></span> <br>

                                                        <span class="sale-status">Status: <?= $status; ?></span>

                                                        <div class="sale-type">
                                                            <h4 class="fw-bold"><?= $plotType; ?></h4>
                                                            <h4 class="fw-bold"> <?= $price; ?></h4>
                                                        </div>
                                                        <div class="sale-description d-none d-lg-block">
                                                            <?= $saleDescription; ?>
                                                        </div>
                                                        <div class="sale-description d-lg-none">
                                                            <?php
                                                                $raw_content 		= $saleDescription;
                                                                $trimmed_content	= wp_trim_words( $raw_content, '32' );
                                                                $clean_excerpt		= apply_filters( 'the_excerpt', $trimmed_content );
                                                                echo $clean_excerpt;
                                                            ?>
                                                        </div>
                                                        <div class="more-button">
                                                            <a class="btn btn-primary" href="<?php echo esc_url( $linkURL ); ?>"><span><?= $linkTitle; ?></span></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </figcaption>
                                        </figure>
                                    <?php }
                                endwhile;
                                wp_reset_postdata(); ?>
                            </div>
                        </section> 
                    </div>
                    <div class="tab-pane fade" id="walkthrough" role="tabpanel" aria-labelledby="walkthrough-tab">
                    <iframe class="col-10 mx-atuo" height="800" src="<?= $matterport; ?>" frameborder="0" allowfullscreen allow="xr-spatial-tracking"></iframe>
                    </div>
                    <div class="tab-pane fade" id="lodge-availability" role="tabpanel" aria-labelledby="lodge-availability-tab">
                        <?php if( $plots->have_posts() ) { ?>
                            <div class="container-fluid lodge-availability-container">
                                <div class="row table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th scope="col">Lodge No.</th>
                                                <th scope="col">Lodge Type</th>
                                                <th scope="col">Status</th>
                                                <th scope="col">Bedrooms</th>
                                                <th scope="col"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php while ( $plots->have_posts() ) : $plots->the_post(); 
                                                $plotNumber = get_field('plot_number', get_the_ID());
                                                $plotType = get_field('lodge_type', get_the_ID()); 
                                                $plotStatus = get_field('plot_status', get_the_ID());
                                                $bedrooms = get_field('number_of_bedrooms', get_the_ID());
                                                $link = get_permalink();

                                                if($plotStatus == 'sale') {
                                                    $status = 'Available';
                                                } elseif ($plotStatus == 'reserve') {
                                                    $status = 'Reserved';
                                                } else {
                                                    $status = 'Sold';
                                                }
                                            ?>
                                                <tr>
                                                    <td><?= $plotNumber; ?></td>
                                                    <td><?= $plotType; ?></td>
                                                    <td><?= $status; ?></td>
                                                    <td><?= $bedrooms; ?></td>
                                                    <td><a href="<?= $link; ?>">View</a></td>
                                                </tr>
                                            <?php endwhile;

                                            wp_reset_postdata(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="container-fluid">
                                <div class="row">
                                    <p>We have no price list to show you at the moment</p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="tab-pane fade" id="location" role="tabpanel" aria-labelledby="location-tab">
                        <div class="container-fluid for-sale-tab-container">
                            <div class="row">
                                <div class="col-10 d-flex justify-content-center">
                                    <?= $locationMap; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>