<section class="experience-plots">
    <div class="container-xxl experiences-container">
        <div class="row">
            <?php if( have_rows('experiences') ):
                while( have_rows('experiences') ) : the_row();
                    $experienceType = get_sub_field('experience_type');

                    if($experienceType == 'internal') {
                        $post = get_sub_field('choose_experience');
                        setup_postdata($post);
                        $image = get_the_post_thumbnail_url(get_the_ID(),'card'); ?>

                        <div class="col-lg-3 col-md-6 col-sm-12 mx-auto experience-card d-flex align-items-end justify-content-center" style="background-image:url('<?= $image; ?>');">
                            <?php
                            $title = get_the_title();
                            $link = get_permalink();
                            ?>

                            <div class="d-grid gap-2 d-flex experience-button">
                                <a class="btn btn-primary" href="<?= $link; ?>"><span><?= $title; ?></span></a>
                            </div>
                        </div>

                        <?php wp_reset_postdata(); ?>
                    <?php } else {
                        $image = wp_get_attachment_image_url(get_sub_field('experience_image'),'card'); 
                        $title = get_sub_field('experience_text');
                        $link = get_sub_field('experience_url');
                        ?>

                        <div class="col-lg-3 col-md-6 col-sm-12 mx-auto experience-card d-flex align-items-end justify-content-center" style="background-image:url('<?= $image; ?>');">
                            <div class="d-grid gap-2 d-flex experience-button">
                                <a class="btn btn-primary" href="<?= $link; ?>" target="_blank"><span><?= $title; ?></span></a>
                            </div>
                        </div>
                    <?php }
                endwhile;
            else : ?>
                <p>We currently have no experiences available, please try again later</p>
            <?php endif; ?>
        </div>
    </div>
</div>