<?php
//get our plot information
$type = get_field('lodge_type');
$bedrooms = get_field('number_of_bedrooms');
$bathrooms = get_field('number_of_bathrooms');
$locations = get_the_terms( get_the_ID(), 'locations' );
$location = $locations[0]->name;
$price = get_field('lodge_price');
$hideEnquiry = get_field('hide_enquire_button');
$enquireLink = get_field('enquire_button_link');

if( $enquireLink ): 
    $link_url = $enquireLink['url'];
    $link_title = $enquireLink['title'];
    $link_target = $enquireLink['target'] ? $link['target'] : '_self';
else :
    $link_url = '';
    $link_title = 'Enquire';
    $link_target = '_self';
endif;
?>

<div <?php post_class("lodge-single"); ?>>
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-4">
                <h3>Overview</h3>

                <div class="overview-title">
                    Lodge Type
                </div>

                <div class="overview-info">
                    <?= $type; ?>
                </div>

                <div class="overview-title">
                    Bedrooms
                </div>

                <div class="overview-info">
                    <?= $bedrooms; ?>
                </div>

                <div class="overview-title">
                    Bathrooms
                </div>

                <div class="overview-info">
                    <?= $bathrooms; ?>
                </div>
                
                <?php if(!$hideEnquiry) { ?>
                    <div class="overview-enquiry">
                        <a class="btn btn-primary" href="<?= $link_url; ?>"><span><?= $link_title; ?></span></a>
                    </div>
                <?php } ?>
            </div>
            <div class="col-md-6">
                <div class="row align-items-center">
                    <div class="col-7">
                        <h1 class="fw-bold"><?= get_the_title();?>, <?= $location; ?></h1>
                    </div>
                    <div class="col-3">
                        <h2 class="fw-bold"><?= $price; ?></h2>
                    </div>
                </div>
                <div class="single-content-container">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    if(get_field('sections')) { ?>
        <div class="flexible-layout">
          <?php Blue2\Scruffy\Utils::flexibleLoop('sections'); ?>
        </div>
    <?php } ?>
</div>
