<?php
$lodgeFeatures = get_field('lodge_features');
$walkthrough = get_field('lodge_walkthrough');
$floorPlan = get_field('lodge_floor_plan');

$hideLodgeFeatures = get_field('hide_lodge_features');
$hideWalkthrough = get_field('hide_3d_walkthrough');
$hideFloorPlan = get_field('hide_floor_plan');


$locations = get_the_terms( get_the_ID(), 'locations' );
$term = $locations[0]->slug;

$sitePlan = get_field($term . '-site-map' , 'options');

$lodges = [ 
    'esk' => 365,
    'earn' => 364,
    'tweed' => 296
];

$args = array(  
    'post_type' => 'plot',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'tax_query' => array(
        array(
            'taxonomy' => 'locations',
            'field' => 'slug',
            'terms' => $term
        )
    )
);

$plots = new WP_Query( $args );

$lodgeInfo = Blue2\Scruffy\Controllers\MapController::getLodgeInfo($term);
?>

<section class="lodge-tab-section">
    <div class="container-xxl">
        <div class="row">
            <div class="col-md-10">
                <ul class="nav nav-tabs" id="lodgeTab" role="tablist">
                    <?php if(!$hideLodgeFeatures) { ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="key-features-tab" data-bs-toggle="tab" data-bs-target="#key-features" type="button" role="tab" aria-controls="key-features" aria-selected="true">Key Features</button>
                        </li>
                    <?php } 
                    if(!$hideWalkthrough) { ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php if($hideLodgeFeatures) { echo 'active'; } ?>" id="lodge-walkthrough-tab" data-bs-toggle="tab" data-bs-target="#lodge-walkthrough" type="button" role="tab" aria-controls="lodge-walkthrough" aria-selected="false">3D Walk Through</button>
                        </li>
                    <?php }
                    if(!$hideFloorPlan) { ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php if($hideLodgeFeatures && $hideWalkthrough) { echo 'active'; } ?>" id="floor-layout-tab" data-bs-toggle="tab" data-bs-target="#floor-layout" type="button" role="tab" aria-controls="floor-layout" aria-selected="false">Floor Layout</button>
                        </li>
                    <?php } ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="site-plan-tab" data-bs-toggle="tab" data-bs-target="#site-plan" type="button" role="tab" aria-controls="site-plan" aria-selected="false">Site Plan</button>
                    </li>
                </ul>
                <div class="tab-content" id="lodgeTabContent">
                    <?php if(!$hideLodgeFeatures) { ?>
                        <div class="tab-pane fade show active" id="key-features" role="tabpanel" aria-labelledby="key-features-tab">
                            <?= $lodgeFeatures; ?>
                        </div>
                    <?php } 
                    if(!$hideWalkthrough) { ?>
                        <div class="tab-pane fade show <?php if($hideLodgeFeatures) { echo 'active'; } ?>" id="lodge-walkthrough" role="tabpanel" aria-labelledby="lodge-walkthrough-tab">
                            <div class="matterport-container col-10 mx-auto">
                                <iframe class="col-10 mx-atuo" height="800" src="<?= $walkthrough; ?>" frameborder="0" allowfullscreen allow="xr-spatial-tracking"></iframe>
                            </div>
                        </div>
                    <?php } 
                    if(!$hideFloorPlan) { ?>
                        <div class="tab-pane fade show <?php if($hideLodgeFeatures && $hideWalkthrough) { echo 'active'; } ?>" id="floor-layout" role="tabpanel" aria-labelledby="floor-layout-tab">
                            <div class="col-10">
                                <img class="img-fluid mx-auto d-block" src="<?= $floorPlan; ?>" alt="Lodge Floor Plan" />
                            </div>
                        </div>
                    <?php } ?>
                    <div class="tab-pane fade" id="site-plan" role="tabpanel" aria-labelledby="site-plan-tab">
                        <section class="area-map">
                            <img class="map img-fluid" src="<?= $sitePlan; ?>" alt="Map of location" />
                            <div class="lodge-pins">
                                <?php while ( $plots->have_posts() ) : $plots->the_post();
                                    $saleStatus = get_field('plot_status', get_the_ID());
                                    $saleDescription = get_field('sale_description');
                                    $locations = get_the_terms( get_the_ID(), 'locations' );
                                    $location = $locations[0]->name;
                                    $image = get_field('sale_image', get_the_ID());
                                    $title = get_the_title();
                                    $plotType = get_field('lodge_type', get_the_ID());
                                    $plotNumber = get_field('plot_number', get_the_ID());
                                    $price = get_field('lodge_price', get_the_ID());
                                    $mapLink = get_field('2d_read_more_button');

                                    if( $mapLink ): 
                                        $linkURL = $mapLink['url'];
                                        $linkTitle = $mapLink['title'];
                                        
                                    else :
                                        $linkURL = get_permalink();
                                        $linkTitle = 'Read More';
                                    endif;

                                    if($saleStatus == 'sale') {
                                        $status = 'Availabe';
                                    } elseif ($saleStatus == 'reserve') {
                                        $status = 'Reserved';
                                    } else {
                                        $status = 'Sold';
                                    }
                                    if(isset($plotNumber) && isset($plotType))
                                    { ?>
                                        <figure class="lodge lodge-<?= strtolower($plotType); ?>">
                                            <a class="lodge-link" href="#" onclick="return false;" style="left: <?= $lodgeInfo[$plotNumber]['left']; ?>; top: <?= $lodgeInfo[$plotNumber]['top']; ?>; transform: rotate(<?= $lodgeInfo[$plotNumber]['rotate']; ?>);">
                                                <img class="img-fluid" src="<?=get_template_directory_uri();?>/dist/images/target-<?= strtolower($plotType); ?>.svg" alt="target pin" />
                                            </a>
                                            <figcaption class="lodge-detail">
                                                <div class="lodge-sticky-panel">
                                                    <div class="close"><i class="fas fa-times"></i></div>
                                                    <img class="img-fluid" src="<?= $image; ?>" alt="For Sale Image" />

                                                    <div class="sale-info">

                                                        <span class="sale-title"><?= $title; ?> - <?= $location; ?></span> <br>

                                                        <span class="sale-status">Status: <?= $status; ?></span>

                                                        <div class="sale-type">
                                                            <h4 class="fw-bold"><?= $plotType; ?></h4>
                                                            <h4 class="fw-bold"> <?= $price; ?></h4>
                                                        </div>
                                                        <div class="sale-description d-none d-lg-block">
                                                            <?= $saleDescription; ?>
                                                        </div>
                                                        <div class="sale-description d-lg-none">
                                                            <?php
                                                                $raw_content 		= $saleDescription;
                                                                $trimmed_content	= wp_trim_words( $raw_content, '32' );
                                                                $clean_excerpt		= apply_filters( 'the_excerpt', $trimmed_content );
                                                                echo $clean_excerpt;
                                                            ?>
                                                        </div>
                                                        <div class="more-button">
                                                            <a class="btn btn-primary" href="<?php echo esc_url( $linkURL ); ?>"><span><?= $linkTitle; ?></span></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </figcaption>
                                        </figure>
                                    <?php }
                                endwhile;
                                wp_reset_postdata(); ?>
                            </div>
                        </section> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>