<?php
/**
 * The template for displaying 404 pages (Not Found)
 */

get_header(); 
if(get_field('404_page_image', 'options')) {
    $image = get_field('404_page_image', 'options');
} else {
    $image = get_template_directory_uri() . '/dist/images/404-image.jpg';
}
?>

<div <?php post_class('not-found-container'); ?>>
    <div class="container-xxl">
        <div class="row">
            <div class="col-10">
                <div class="image-container">
                    <img class="img-fluid d-block mx-auto" src="<?= $image; ?>" />
                </div>

                <div class="not-found-links">
                    <p>Try one of the pages below, or alternatively try our search box</p>
                    <?php
                        wp_nav_menu( 
                            [
                                'theme_location' => '404_links',
                                'menu_class' => 'not-found-links-menu'
                            ]
                        );
                    ?>
                </div>

                <div class="not-found-search">
                    <form action="/" method="get">
                        <div class="input-group mx-auto search-input-container">
                            <input class="form-control py-2 border-end-0 border rounded-start" type="search" placeholder="Search" id="search-input" name="s" value="<?php the_search_query(); ?>">
                            <span class="input-group-append">
                                <div class="input-group-text bg-white rounded-end">
                                    <i class="fa fa-search"></i>
                                </div>
                            </span>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>