<?php
$backgroundType = get_sub_field('background_type');
$bgImage = get_sub_field('background_image');
$setHeight =  get_sub_field('set_section_height');
$sectionHeight = get_sub_field('section_height');
$sectionOptions = get_sub_field('section_options');

switch ($sectionOptions) {
    case '90-10':
        $leftSize = 'col-md-9';
        $rightSize = 'col-md-1';
        break;
    case '10-90':
        $leftSize = 'col-md-1';
        $rightSize = 'col-md-9';
        break;
    case '80-20':
        $leftSize = 'col-md-8';
        $rightSize = 'col-md-2';
        break;
    case '20-80':
        $leftSize = 'col-md-2';
        $rightSize = 'col-md-8';
        break;
    case '70-30':
        $leftSize = 'col-md-7';
        $rightSize = 'col-md-3';
        break;
    case '30-70':
        $leftSize = 'col-md-3';
        $rightSize = 'col-md-7';
        break;
    case '60-40':
        $leftSize = 'col-md-6';
        $rightSize = 'col-md-4';
        break;
    case '40-60':
        $leftSize = 'col-md-4';
        $rightSize = 'col-md-6';
        break;
}

switch ($backgroundType) {
    case 'none':
        $backgroundType = '';
        break;
    case 'light_bg':
        $backgroundType = 'bg-light';
        break;
    case 'dark_bg':
        $backgroundType = 'bg-dark';
        break;
}
?>

<section class="flexible_section <?= $backgroundType; ?>" style="background-image: url('<?= $bgImage; ?>'); <?php if ($setHeight == 'True') { ?>height:<?= $sectionHeight; ?>px; <?php } ?>">
    <div class="container-xxl cms">
        <div class="row">
            <div class="left-column cms <?= $leftSize; ?>">
                <?= get_sub_field('content_left'); ?>
            </div>
            <div class="right-column cms <?= $rightSize; ?>">
                <?= get_sub_field('content_right'); ?>
            </div>
        </div>
    </div>
</section>