<?php

namespace Blue2\Scruffy\Controllers;

class SiteController
{
    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'mlv_enqueue_scripts']);

        add_theme_support( 'yoast-seo-breadcrumbs' );
    }

    public function mlv_enqueue_scripts()
    {
        wp_enqueue_script( 'slick-js', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array(), false, true);

        wp_enqueue_style('slick-css','https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css');

        wp_enqueue_script( 'rwd-image-maps', 'https://cdnjs.cloudflare.com/ajax/libs/jQuery-rwdImageMaps/1.6/jquery.rwdImageMaps.min.js', array('jquery'), false, true);
    }

    public static function auto_copyright($year = 'auto') {
        if(intval($year) == 'auto') { 
            $year = date('Y'); 
        }

        if(intval($year) == date('Y')) { 
            echo intval($year); 
        }

        if(intval($year) < date('Y')) { 
            echo intval($year) . ' - ' . date('Y'); 
        }

        if(intval($year) > date('Y')) { 
            echo date('Y'); 
        }
    }
}
